/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.RandomKeyTransferMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestRandomKeyTransfer;
import tech.carpentum.sdk.payment.model.IdentifyingReference;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public interface RandomKeyTransferMethod
extends PayoutMethod {
    public static final PayoutMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayoutMethod.PaymentMethodCode.RANDOM_KEY_TRANSFER;

    @NotNull
    public String getRandomKey();

    @NotNull
    public Optional<AccountPayoutRequestRandomKeyTransfer> getAccount();

    @NotNull
    public IdentifyingReference getIdentifyingReference();

    @NotNull
    public static Builder builder(RandomKeyTransferMethod copyOf) {
        Builder builder = RandomKeyTransferMethod.builder();
        builder.randomKey(copyOf.getRandomKey());
        builder.account(copyOf.getAccount().orElse(null));
        builder.identifyingReference(copyOf.getIdentifyingReference());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new RandomKeyTransferMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder randomKey(String var1);

        public boolean isRandomKeyDefined();

        @NotNull
        public Builder account(AccountPayoutRequestRandomKeyTransfer var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder identifyingReference(IdentifyingReference var1);

        public boolean isIdentifyingReferenceDefined();

        @NotNull
        public RandomKeyTransferMethod build();
    }
}

