/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.OfflineMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestOffline;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface OfflineMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.OFFLINE;

    @NotNull
    public Optional<AccountPayinRequestOffline> getAccount();

    @NotNull
    public Optional<String> getPaymentOperatorCode();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public Optional<String> getProductId();

    @NotNull
    public Optional<String> getTaxId();

    @NotNull
    public static Builder builder(OfflineMethod copyOf) {
        Builder builder = OfflineMethod.builder();
        builder.account(copyOf.getAccount().orElse(null));
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode().orElse(null));
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        builder.productId(copyOf.getProductId().orElse(null));
        builder.taxId(copyOf.getTaxId().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new OfflineMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestOffline var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public Builder productId(String var1);

        public boolean isProductIdDefined();

        @NotNull
        public Builder taxId(String var1);

        public boolean isTaxIdDefined();

        @NotNull
        public OfflineMethod build();
    }
}

