/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class BusinessValidationError {
    @NotNull
    public final String code;
    @NotNull
    public final Optional<String> description;
    @NotNull
    public final Optional<String> attrCode;
    @NotNull
    public final Optional<String> attrValue;
    private final int hashCode;
    private final String toString;

    protected <M extends BusinessValidationError, B extends Builder<M, B>> BusinessValidationError(Builder<M, B> builder) {
        this.code = Objects.requireNonNull(builder.code, "Property 'code' is required.");
        this.description = Optional.ofNullable(builder.description);
        this.attrCode = Optional.ofNullable(builder.attrCode);
        this.attrValue = Optional.ofNullable(builder.attrValue);
        this.hashCode = Objects.hash(this.code, this.description, this.attrCode, this.attrValue);
        this.toString = this.getClass().getSimpleName() + "(code=" + this.code + ", description=" + this.description + ", attrCode=" + this.attrCode + ", attrValue=" + this.attrValue + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        BusinessValidationError that = (BusinessValidationError)obj;
        if (!this.code.equals(that.code)) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.attrCode.equals(that.attrCode)) {
            return false;
        }
        return this.attrValue.equals(that.attrValue);
    }

    public String toString() {
        return this.toString;
    }

    public static abstract class Builder<M extends BusinessValidationError, B extends Builder<M, B>> {
        private String code = null;
        private String description = null;
        private String attrCode = null;
        private String attrValue = null;

        protected Builder() {
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder attrCode(String attrCode) {
            this.attrCode = attrCode;
            return this;
        }

        public Builder attrValue(String attrValue) {
            this.attrValue = attrValue;
            return this;
        }

        public abstract M build();
    }
}

