/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.BalanceImpl;
import tech.carpentum.sdk.payment.model.CurrencyCode;

@JsonClass(generateAdapter=false)
public interface Balance {
    @NotNull
    public CurrencyCode getCurrencyCode();

    @NotNull
    public BigDecimal getBalance();

    @NotNull
    public BigDecimal getAvailableBalance();

    @NotNull
    public BigDecimal getPendingSettlementAmount();

    @NotNull
    public BigDecimal getPendingPayoutAmount();

    @NotNull
    public OffsetDateTime getLastBalanceMovement();

    @NotNull
    public static Builder builder(Balance copyOf) {
        Builder builder = Balance.builder();
        builder.currencyCode(copyOf.getCurrencyCode());
        builder.balance(copyOf.getBalance());
        builder.availableBalance(copyOf.getAvailableBalance());
        builder.pendingSettlementAmount(copyOf.getPendingSettlementAmount());
        builder.pendingPayoutAmount(copyOf.getPendingPayoutAmount());
        builder.lastBalanceMovement(copyOf.getLastBalanceMovement());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new BalanceImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder currencyCode(CurrencyCode var1);

        public boolean isCurrencyCodeDefined();

        @NotNull
        public Builder balance(BigDecimal var1);

        public boolean isBalanceDefined();

        @NotNull
        public Builder availableBalance(BigDecimal var1);

        public boolean isAvailableBalanceDefined();

        @NotNull
        public Builder pendingSettlementAmount(BigDecimal var1);

        public boolean isPendingSettlementAmountDefined();

        @NotNull
        public Builder pendingPayoutAmount(BigDecimal var1);

        public boolean isPendingPayoutAmountDefined();

        @NotNull
        public Builder lastBalanceMovement(OffsetDateTime var1);

        public boolean isLastBalanceMovementDefined();

        @NotNull
        public Balance build();
    }
}

