/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AvailablePayoutOptionImpl;
import tech.carpentum.sdk.payment.model.PaymentOperatorOutgoing;
import tech.carpentum.sdk.payment.model.PayoutMethodCode;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public interface AvailablePayoutOption {
    @NotNull
    public PayoutMethodCode getPaymentMethodCode();

    @NotNull
    public @NotNull List<@NotNull PaymentOperatorOutgoing> getPaymentOperators();

    @NotNull
    public Optional<SegmentCode> getSegmentCode();

    @NotNull
    public static Builder builder(AvailablePayoutOption copyOf) {
        Builder builder = AvailablePayoutOption.builder();
        builder.paymentMethodCode(copyOf.getPaymentMethodCode());
        builder.paymentOperators(copyOf.getPaymentOperators());
        builder.segmentCode(copyOf.getSegmentCode().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new AvailablePayoutOptionImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder paymentMethodCode(PayoutMethodCode var1);

        public boolean isPaymentMethodCodeDefined();

        @NotNull
        public Builder paymentOperators(List<@NotNull PaymentOperatorOutgoing> var1);

        @NotNull
        public Builder paymentOperatorsAdd(PaymentOperatorOutgoing var1);

        @NotNull
        public Builder paymentOperatorsAddAll(List<@NotNull PaymentOperatorOutgoing> var1);

        @NotNull
        public Builder segmentCode(SegmentCode var1);

        public boolean isSegmentCodeDefined();

        @NotNull
        public AvailablePayoutOption build();
    }
}

