/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.IntervalNumberTo;
import tech.carpentum.sdk.payment.model.PaymentOperatorOption;
import tech.carpentum.sdk.payment.model.SettlementMethodCode;
import tech.carpentum.sdk.payment.model.SettlementPaymentOption;

@JsonClass(generateAdapter=false)
public class SettlementPaymentOptionImpl
implements SettlementPaymentOption {
    private final SettlementMethodCode paymentMethodCode;
    private final CurrencyCode currencyCode;
    private final IntervalNumberTo transactionAmountLimit;
    private final Boolean isAvailable;
    private final List<@NotNull PaymentOperatorOption> paymentOperators;
    private final int hashCode;
    private final String toString;

    @Override
    public SettlementMethodCode getPaymentMethodCode() {
        return this.paymentMethodCode;
    }

    @Override
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public IntervalNumberTo getTransactionAmountLimit() {
        return this.transactionAmountLimit;
    }

    @Override
    public Boolean getIsAvailable() {
        return this.isAvailable;
    }

    @Override
    public List<@NotNull PaymentOperatorOption> getPaymentOperators() {
        return this.paymentOperators;
    }

    private SettlementPaymentOptionImpl(BuilderImpl builder) {
        this.paymentMethodCode = Objects.requireNonNull(builder.paymentMethodCode, "Property 'paymentMethodCode' is required.");
        this.currencyCode = Objects.requireNonNull(builder.currencyCode, "Property 'currencyCode' is required.");
        this.transactionAmountLimit = Objects.requireNonNull(builder.transactionAmountLimit, "Property 'transactionAmountLimit' is required.");
        this.isAvailable = Objects.requireNonNull(builder.isAvailable, "Property 'isAvailable' is required.");
        this.paymentOperators = Collections.unmodifiableList(builder.paymentOperators);
        this.hashCode = Objects.hash(this.paymentMethodCode, this.currencyCode, this.transactionAmountLimit, this.isAvailable, this.paymentOperators);
        this.toString = builder.type + "(paymentMethodCode=" + this.paymentMethodCode + ", currencyCode=" + this.currencyCode + ", transactionAmountLimit=" + this.transactionAmountLimit + ", isAvailable=" + this.isAvailable + ", paymentOperators=" + this.paymentOperators + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SettlementPaymentOptionImpl)) {
            return false;
        }
        SettlementPaymentOptionImpl that = (SettlementPaymentOptionImpl)obj;
        if (!Objects.equals(this.paymentMethodCode, that.paymentMethodCode)) {
            return false;
        }
        if (!Objects.equals(this.currencyCode, that.currencyCode)) {
            return false;
        }
        if (!Objects.equals(this.transactionAmountLimit, that.transactionAmountLimit)) {
            return false;
        }
        if (!Objects.equals(this.isAvailable, that.isAvailable)) {
            return false;
        }
        return Objects.equals(this.paymentOperators, that.paymentOperators);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements SettlementPaymentOption.Builder {
        private SettlementMethodCode paymentMethodCode = null;
        private CurrencyCode currencyCode = null;
        private IntervalNumberTo transactionAmountLimit = null;
        private Boolean isAvailable = null;
        private List<@NotNull PaymentOperatorOption> paymentOperators = new ArrayList<PaymentOperatorOption>();
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("SettlementPaymentOption");
        }

        @Override
        public BuilderImpl paymentMethodCode(SettlementMethodCode paymentMethodCode) {
            this.paymentMethodCode = paymentMethodCode;
            return this;
        }

        @Override
        public boolean isPaymentMethodCodeDefined() {
            return this.paymentMethodCode != null;
        }

        @Override
        public BuilderImpl currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public boolean isCurrencyCodeDefined() {
            return this.currencyCode != null;
        }

        @Override
        public BuilderImpl transactionAmountLimit(IntervalNumberTo transactionAmountLimit) {
            this.transactionAmountLimit = transactionAmountLimit;
            return this;
        }

        @Override
        public boolean isTransactionAmountLimitDefined() {
            return this.transactionAmountLimit != null;
        }

        @Override
        public BuilderImpl isAvailable(Boolean isAvailable) {
            this.isAvailable = isAvailable;
            return this;
        }

        @Override
        public boolean isIsAvailableDefined() {
            return this.isAvailable != null;
        }

        @Override
        public BuilderImpl paymentOperators(List<@NotNull PaymentOperatorOption> paymentOperators) {
            this.paymentOperators.clear();
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAdd(PaymentOperatorOption item) {
            if (item != null) {
                this.paymentOperators.add(item);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAddAll(List<@NotNull PaymentOperatorOption> paymentOperators) {
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public SettlementPaymentOptionImpl build() {
            return new SettlementPaymentOptionImpl(this);
        }
    }
}

