/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestRandomKeyTransfer;
import tech.carpentum.sdk.payment.model.IdentifyingReference;
import tech.carpentum.sdk.payment.model.PayoutMethod;
import tech.carpentum.sdk.payment.model.RandomKeyTransferMethod;

@JsonClass(generateAdapter=false)
public class RandomKeyTransferMethodImpl
implements RandomKeyTransferMethod {
    private final String randomKey;
    private final Optional<AccountPayoutRequestRandomKeyTransfer> account;
    private final IdentifyingReference identifyingReference;
    private final int hashCode;
    private final String toString;

    @Override
    public String getRandomKey() {
        return this.randomKey;
    }

    @Override
    public Optional<AccountPayoutRequestRandomKeyTransfer> getAccount() {
        return this.account;
    }

    @Override
    public IdentifyingReference getIdentifyingReference() {
        return this.identifyingReference;
    }

    @Override
    public PayoutMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private RandomKeyTransferMethodImpl(BuilderImpl builder) {
        this.randomKey = Objects.requireNonNull(builder.randomKey, "Property 'randomKey' is required.");
        this.account = Optional.ofNullable(builder.account);
        this.identifyingReference = Objects.requireNonNull(builder.identifyingReference, "Property 'identifyingReference' is required.");
        this.hashCode = Objects.hash(this.randomKey, this.account, this.identifyingReference);
        this.toString = builder.type + "(randomKey=" + this.randomKey + ", account=" + this.account + ", identifyingReference=" + this.identifyingReference + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RandomKeyTransferMethodImpl)) {
            return false;
        }
        RandomKeyTransferMethodImpl that = (RandomKeyTransferMethodImpl)obj;
        if (!Objects.equals(this.randomKey, that.randomKey)) {
            return false;
        }
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        return Objects.equals(this.identifyingReference, that.identifyingReference);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements RandomKeyTransferMethod.Builder {
        private String randomKey = null;
        private AccountPayoutRequestRandomKeyTransfer account = null;
        private IdentifyingReference identifyingReference = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("RandomKeyTransferMethod");
        }

        @Override
        public BuilderImpl randomKey(String randomKey) {
            this.randomKey = randomKey;
            return this;
        }

        @Override
        public boolean isRandomKeyDefined() {
            return this.randomKey != null;
        }

        @Override
        public BuilderImpl account(AccountPayoutRequestRandomKeyTransfer account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl identifyingReference(IdentifyingReference identifyingReference) {
            this.identifyingReference = identifyingReference;
            return this;
        }

        @Override
        public boolean isIdentifyingReferenceDefined() {
            return this.identifyingReference != null;
        }

        @Override
        public RandomKeyTransferMethodImpl build() {
            return new RandomKeyTransferMethodImpl(this);
        }
    }
}

