/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestQrisPay;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.QrisPayMethod;

@JsonClass(generateAdapter=false)
public class QrisPayMethodImpl
implements QrisPayMethod {
    private final Optional<AccountPayinRequestQrisPay> account;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<AccountPayinRequestQrisPay> getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private QrisPayMethodImpl(BuilderImpl builder) {
        this.account = Optional.ofNullable(builder.account);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.account, this.emailAddress);
        this.toString = builder.type + "(account=" + this.account + ", emailAddress=" + this.emailAddress + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QrisPayMethodImpl)) {
            return false;
        }
        QrisPayMethodImpl that = (QrisPayMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        return Objects.equals(this.emailAddress, that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements QrisPayMethod.Builder {
        private AccountPayinRequestQrisPay account = null;
        private String emailAddress = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("QrisPayMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestQrisPay account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public QrisPayMethodImpl build() {
            return new QrisPayMethodImpl(this);
        }
    }
}

