/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.ExternalProviders;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public class PaymentOperatorIncomingImpl
implements PaymentOperatorIncoming {
    private final String code;
    private final String name;
    private final Optional<ExternalProviders> externalProviders;
    private final int hashCode;
    private final String toString;

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<ExternalProviders> getExternalProviders() {
        return this.externalProviders;
    }

    private PaymentOperatorIncomingImpl(BuilderImpl builder) {
        this.code = Objects.requireNonNull(builder.code, "Property 'code' is required.");
        this.name = Objects.requireNonNull(builder.name, "Property 'name' is required.");
        this.externalProviders = Optional.ofNullable(builder.externalProviders);
        this.hashCode = Objects.hash(this.code, this.name, this.externalProviders);
        this.toString = builder.type + "(code=" + this.code + ", name=" + this.name + ", externalProviders=" + this.externalProviders + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentOperatorIncomingImpl)) {
            return false;
        }
        PaymentOperatorIncomingImpl that = (PaymentOperatorIncomingImpl)obj;
        if (!Objects.equals(this.code, that.code)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.externalProviders, that.externalProviders);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PaymentOperatorIncoming.Builder {
        private String code = null;
        private String name = null;
        private ExternalProviders externalProviders = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PaymentOperatorIncoming");
        }

        @Override
        public BuilderImpl code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public boolean isCodeDefined() {
            return this.code != null;
        }

        @Override
        public BuilderImpl name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public boolean isNameDefined() {
            return this.name != null;
        }

        @Override
        public BuilderImpl externalProviders(ExternalProviders externalProviders) {
            this.externalProviders = externalProviders;
            return this;
        }

        @Override
        public boolean isExternalProvidersDefined() {
            return this.externalProviders != null;
        }

        @Override
        public PaymentOperatorIncomingImpl build() {
            return new PaymentOperatorIncomingImpl(this);
        }
    }
}

