/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import tech.carpentum.sdk.payment.model.PaymentLocation;

@JsonClass(generateAdapter=false)
public class PaymentLocationImpl
implements PaymentLocation {
    private final String postalCode;
    private final String city;
    private final String district;
    private final int hashCode;
    private final String toString;

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    @Override
    public String getDistrict() {
        return this.district;
    }

    private PaymentLocationImpl(BuilderImpl builder) {
        this.postalCode = Objects.requireNonNull(builder.postalCode, "Property 'postalCode' is required.");
        this.city = Objects.requireNonNull(builder.city, "Property 'city' is required.");
        this.district = Objects.requireNonNull(builder.district, "Property 'district' is required.");
        this.hashCode = Objects.hash(this.postalCode, this.city, this.district);
        this.toString = builder.type + "(postalCode=" + this.postalCode + ", city=" + this.city + ", district=" + this.district + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentLocationImpl)) {
            return false;
        }
        PaymentLocationImpl that = (PaymentLocationImpl)obj;
        if (!Objects.equals(this.postalCode, that.postalCode)) {
            return false;
        }
        if (!Objects.equals(this.city, that.city)) {
            return false;
        }
        return Objects.equals(this.district, that.district);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PaymentLocation.Builder {
        private String postalCode = null;
        private String city = null;
        private String district = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PaymentLocation");
        }

        @Override
        public BuilderImpl postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        @Override
        public boolean isPostalCodeDefined() {
            return this.postalCode != null;
        }

        @Override
        public BuilderImpl city(String city) {
            this.city = city;
            return this;
        }

        @Override
        public boolean isCityDefined() {
            return this.city != null;
        }

        @Override
        public BuilderImpl district(String district) {
            this.district = district;
            return this;
        }

        @Override
        public boolean isDistrictDefined() {
            return this.district != null;
        }

        @Override
        public PaymentLocationImpl build() {
            return new PaymentLocationImpl(this);
        }
    }
}

