/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountCustomerUsedForPaymentResponseOnline;

@JsonClass(generateAdapter=false)
public class AccountCustomerUsedForPaymentResponseOnlineImpl
implements AccountCustomerUsedForPaymentResponseOnline {
    private final Optional<String> accountName;
    private final Optional<String> accountNumber;
    private final Optional<String> accountType;
    private final Optional<String> bankCode;
    private final Optional<String> bankName;
    private final Optional<String> bankBranch;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<String> getAccountName() {
        return this.accountName;
    }

    @Override
    public Optional<String> getAccountNumber() {
        return this.accountNumber;
    }

    @Override
    public Optional<String> getAccountType() {
        return this.accountType;
    }

    @Override
    public Optional<String> getBankCode() {
        return this.bankCode;
    }

    @Override
    public Optional<String> getBankName() {
        return this.bankName;
    }

    @Override
    public Optional<String> getBankBranch() {
        return this.bankBranch;
    }

    private AccountCustomerUsedForPaymentResponseOnlineImpl(BuilderImpl builder) {
        this.accountName = Optional.ofNullable(builder.accountName);
        this.accountNumber = Optional.ofNullable(builder.accountNumber);
        this.accountType = Optional.ofNullable(builder.accountType);
        this.bankCode = Optional.ofNullable(builder.bankCode);
        this.bankName = Optional.ofNullable(builder.bankName);
        this.bankBranch = Optional.ofNullable(builder.bankBranch);
        this.hashCode = Objects.hash(this.accountName, this.accountNumber, this.accountType, this.bankCode, this.bankName, this.bankBranch);
        this.toString = builder.type + "(accountName=" + this.accountName + ", accountNumber=" + this.accountNumber + ", accountType=" + this.accountType + ", bankCode=" + this.bankCode + ", bankName=" + this.bankName + ", bankBranch=" + this.bankBranch + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountCustomerUsedForPaymentResponseOnlineImpl)) {
            return false;
        }
        AccountCustomerUsedForPaymentResponseOnlineImpl that = (AccountCustomerUsedForPaymentResponseOnlineImpl)obj;
        if (!Objects.equals(this.accountName, that.accountName)) {
            return false;
        }
        if (!Objects.equals(this.accountNumber, that.accountNumber)) {
            return false;
        }
        if (!Objects.equals(this.accountType, that.accountType)) {
            return false;
        }
        if (!Objects.equals(this.bankCode, that.bankCode)) {
            return false;
        }
        if (!Objects.equals(this.bankName, that.bankName)) {
            return false;
        }
        return Objects.equals(this.bankBranch, that.bankBranch);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AccountCustomerUsedForPaymentResponseOnline.Builder {
        private String accountName = null;
        private String accountNumber = null;
        private String accountType = null;
        private String bankCode = null;
        private String bankName = null;
        private String bankBranch = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AccountCustomerUsedForPaymentResponseOnline");
        }

        @Override
        public BuilderImpl accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        @Override
        public boolean isAccountNameDefined() {
            return this.accountName != null;
        }

        @Override
        public BuilderImpl accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        @Override
        public boolean isAccountNumberDefined() {
            return this.accountNumber != null;
        }

        @Override
        public BuilderImpl accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        @Override
        public boolean isAccountTypeDefined() {
            return this.accountType != null;
        }

        @Override
        public BuilderImpl bankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        @Override
        public boolean isBankCodeDefined() {
            return this.bankCode != null;
        }

        @Override
        public BuilderImpl bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        @Override
        public boolean isBankNameDefined() {
            return this.bankName != null;
        }

        @Override
        public BuilderImpl bankBranch(String bankBranch) {
            this.bankBranch = bankBranch;
            return this;
        }

        @Override
        public boolean isBankBranchDefined() {
            return this.bankBranch != null;
        }

        @Override
        public AccountCustomerUsedForPaymentResponseOnlineImpl build() {
            return new AccountCustomerUsedForPaymentResponseOnlineImpl(this);
        }
    }
}

