/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PayinDetailImpl;
import tech.carpentum.sdk.payment.model.CustomerDetail;
import tech.carpentum.sdk.payment.model.MoneyFee;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentProcess;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.SettlementMethod;

@JsonClass(generateAdapter=false)
public interface PayinDetail {
    @NotNull
    public PaymentRequested getPaymentRequested();

    @NotNull
    public PaymentProcess getProcess();

    @NotNull
    public MoneyFee getFee();

    @NotNull
    public PayinMethodResponse getPaymentMethodResponse();

    @NotNull
    public Optional<SettlementMethod> getSettlement();

    @NotNull
    public Optional<CustomerDetail> getCustomer();

    @NotNull
    public static Builder builder(PayinDetail copyOf) {
        Builder builder = PayinDetail.builder();
        builder.paymentRequested(copyOf.getPaymentRequested());
        builder.process(copyOf.getProcess());
        builder.fee(copyOf.getFee());
        builder.paymentMethodResponse(copyOf.getPaymentMethodResponse());
        builder.settlement(copyOf.getSettlement().orElse(null));
        builder.customer(copyOf.getCustomer().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PayinDetailImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder paymentRequested(PaymentRequested var1);

        public boolean isPaymentRequestedDefined();

        @NotNull
        public Builder process(PaymentProcess var1);

        public boolean isProcessDefined();

        @NotNull
        public Builder fee(MoneyFee var1);

        public boolean isFeeDefined();

        @NotNull
        public Builder paymentMethodResponse(PayinMethodResponse var1);

        public boolean isPaymentMethodResponseDefined();

        @NotNull
        public Builder settlement(SettlementMethod var1);

        public boolean isSettlementDefined();

        @NotNull
        public Builder customer(CustomerDetail var1);

        public boolean isCustomerDefined();

        @NotNull
        public PayinDetail build();
    }
}

