/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.VietQRMethodResponseImpl;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.SelectedPaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public interface VietQRMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.VIETQR;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public MoneyPaymentResponse getMoney();

    @NotNull
    public Optional<MoneyVat> getVat();

    @NotNull
    public String getMerchantName();

    @NotNull
    public String getReference();

    @NotNull
    public String getQrName();

    @NotNull
    public String getQrCode();

    @NotNull
    public Optional<SelectedPaymentOperatorIncoming> getPaymentOperator();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(VietQRMethodResponse copyOf) {
        Builder builder = VietQRMethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.money(copyOf.getMoney());
        builder.vat(copyOf.getVat().orElse(null));
        builder.merchantName(copyOf.getMerchantName());
        builder.reference(copyOf.getReference());
        builder.qrName(copyOf.getQrName());
        builder.qrCode(copyOf.getQrCode());
        builder.paymentOperator(copyOf.getPaymentOperator().orElse(null));
        builder.returnUrl(copyOf.getReturnUrl());
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new VietQRMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        public boolean isIdPayinDefined();

        @NotNull
        public Builder idPayment(IdPayment var1);

        public boolean isIdPaymentDefined();

        @NotNull
        public Builder money(MoneyPaymentResponse var1);

        public boolean isMoneyDefined();

        @NotNull
        public Builder vat(MoneyVat var1);

        public boolean isVatDefined();

        @NotNull
        public Builder merchantName(String var1);

        public boolean isMerchantNameDefined();

        @NotNull
        public Builder reference(String var1);

        public boolean isReferenceDefined();

        @NotNull
        public Builder qrName(String var1);

        public boolean isQrNameDefined();

        @NotNull
        public Builder qrCode(String var1);

        public boolean isQrCodeDefined();

        @NotNull
        public Builder paymentOperator(SelectedPaymentOperatorIncoming var1);

        public boolean isPaymentOperatorDefined();

        @NotNull
        public Builder returnUrl(String var1);

        public boolean isReturnUrlDefined();

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        public boolean isAcceptedAtDefined();

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        public boolean isExpireAtDefined();

        @NotNull
        public VietQRMethodResponse build();
    }
}

