/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AvailablePayinOptionVariantCurrency;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodCode;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public class AvailablePayinOptionVariantCurrencyImpl
implements AvailablePayinOptionVariantCurrency {
    private final PayinMethodCode paymentMethodCode;
    private final List<@NotNull PaymentOperatorIncoming> paymentOperators;
    private final Optional<SegmentCode> segmentCode;
    private final Money money;
    private final int hashCode;
    private final String toString;

    @Override
    public PayinMethodCode getPaymentMethodCode() {
        return this.paymentMethodCode;
    }

    @Override
    public List<@NotNull PaymentOperatorIncoming> getPaymentOperators() {
        return this.paymentOperators;
    }

    @Override
    public Optional<SegmentCode> getSegmentCode() {
        return this.segmentCode;
    }

    @Override
    public Money getMoney() {
        return this.money;
    }

    private AvailablePayinOptionVariantCurrencyImpl(BuilderImpl builder) {
        this.paymentMethodCode = Objects.requireNonNull(builder.paymentMethodCode, "Property 'paymentMethodCode' is required.");
        this.paymentOperators = Collections.unmodifiableList(builder.paymentOperators);
        this.segmentCode = Optional.ofNullable(builder.segmentCode);
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.hashCode = Objects.hash(this.paymentMethodCode, this.paymentOperators, this.segmentCode, this.money);
        this.toString = builder.type + "(paymentMethodCode=" + this.paymentMethodCode + ", paymentOperators=" + this.paymentOperators + ", segmentCode=" + this.segmentCode + ", money=" + this.money + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailablePayinOptionVariantCurrencyImpl)) {
            return false;
        }
        AvailablePayinOptionVariantCurrencyImpl that = (AvailablePayinOptionVariantCurrencyImpl)obj;
        if (!Objects.equals(this.paymentMethodCode, that.paymentMethodCode)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperators, that.paymentOperators)) {
            return false;
        }
        if (!Objects.equals(this.segmentCode, that.segmentCode)) {
            return false;
        }
        return Objects.equals(this.money, that.money);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AvailablePayinOptionVariantCurrency.Builder {
        private PayinMethodCode paymentMethodCode = null;
        private List<@NotNull PaymentOperatorIncoming> paymentOperators = new ArrayList<PaymentOperatorIncoming>();
        private SegmentCode segmentCode = null;
        private Money money = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AvailablePayinOptionVariantCurrency");
        }

        @Override
        public BuilderImpl paymentMethodCode(PayinMethodCode paymentMethodCode) {
            this.paymentMethodCode = paymentMethodCode;
            return this;
        }

        @Override
        public boolean isPaymentMethodCodeDefined() {
            return this.paymentMethodCode != null;
        }

        @Override
        public BuilderImpl paymentOperators(List<@NotNull PaymentOperatorIncoming> paymentOperators) {
            this.paymentOperators.clear();
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAdd(PaymentOperatorIncoming item) {
            if (item != null) {
                this.paymentOperators.add(item);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAddAll(List<@NotNull PaymentOperatorIncoming> paymentOperators) {
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public BuilderImpl segmentCode(SegmentCode segmentCode) {
            this.segmentCode = segmentCode;
            return this;
        }

        @Override
        public boolean isSegmentCodeDefined() {
            return this.segmentCode != null;
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public boolean isMoneyDefined() {
            return this.money != null;
        }

        @Override
        public AvailablePayinOptionVariantCurrencyImpl build() {
            return new AvailablePayinOptionVariantCurrencyImpl(this);
        }
    }
}

