/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.io.InterruptedIOException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.EndpointDefinition;
import tech.carpentum.sdk.payment.EndpointWithIdDefinition;
import tech.carpentum.sdk.payment.PaymentContext;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.ClientErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.EnhancedIncomingPaymentsApi;
import tech.carpentum.sdk.payment.internal.api.GetPayinErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.GetTopupErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.PostAvailablePayinOptionsErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.PostAvailableTopUpOptionsErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.PostPayinsErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.AvailablePayinOptionList;
import tech.carpentum.sdk.payment.model.AvailableTopUpOptions;
import tech.carpentum.sdk.payment.model.ExternalReference;
import tech.carpentum.sdk.payment.model.Payin;
import tech.carpentum.sdk.payment.model.PayinAcceptedResponse;
import tech.carpentum.sdk.payment.model.PayinDetail;
import tech.carpentum.sdk.payment.model.PaymentAccountDetail;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.TopUp;
import tech.carpentum.sdk.payment.model.TopUpAcceptedResponse;
import tech.carpentum.sdk.payment.model.TopUpDetail;
import tech.carpentum.sdk.payment.model.TopUpRequested;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ltech/carpentum/sdk/payment/IncomingPaymentsApi;", "", "apiVersion", "", "api", "Ltech/carpentum/sdk/payment/internal/api/EnhancedIncomingPaymentsApi;", "<init>", "(ILtech/carpentum/sdk/payment/internal/api/EnhancedIncomingPaymentsApi;)V", "payinAvailablePaymentOptions", "Ltech/carpentum/sdk/payment/model/AvailablePayinOptionList;", "paymentRequested", "Ltech/carpentum/sdk/payment/model/PaymentRequested;", "createPayin", "Ltech/carpentum/sdk/payment/model/PayinAcceptedResponse;", "idPayin", "", "payin", "Ltech/carpentum/sdk/payment/model/Payin;", "setPayinExternalReference", "", "reference", "getPayin", "Ltech/carpentum/sdk/payment/model/PayinDetail;", "getPayinAccounts", "Ltech/carpentum/sdk/payment/model/PaymentAccountDetail;", "topupAvailablePaymentOptions", "Ltech/carpentum/sdk/payment/model/AvailableTopUpOptions;", "topUpRequested", "Ltech/carpentum/sdk/payment/model/TopUpRequested;", "createTopup", "Ltech/carpentum/sdk/payment/model/TopUpAcceptedResponse;", "idTopUp", "topUp", "Ltech/carpentum/sdk/payment/model/TopUp;", "getTopup", "Ltech/carpentum/sdk/payment/model/TopUpDetail;", "Factory", "payment-client-v2"})
public final class IncomingPaymentsApi {
    @NotNull
    public static final Factory Factory = new Factory(null);
    private final int apiVersion;
    @NotNull
    private final EnhancedIncomingPaymentsApi api;

    private IncomingPaymentsApi(int apiVersion, EnhancedIncomingPaymentsApi api) {
        this.apiVersion = apiVersion;
        this.api = api;
    }

    @NotNull
    public final AvailablePayinOptionList payinAvailablePaymentOptions(@NotNull PaymentRequested paymentRequested) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)paymentRequested, (String)"paymentRequested");
        return (AvailablePayinOptionList)ResponseExceptionUtils.INSTANCE.wrap(PostAvailablePayinOptionsErrorExceptionFactory.Companion.getInstance(), () -> IncomingPaymentsApi.payinAvailablePaymentOptions$lambda$0(this, paymentRequested));
    }

    @NotNull
    public final PayinAcceptedResponse createPayin(@NotNull String idPayin, @NotNull Payin payin) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)payin, (String)"payin");
        return (PayinAcceptedResponse)ResponseExceptionUtils.INSTANCE.wrap(PostPayinsErrorExceptionFactory.Companion.getInstance(), () -> IncomingPaymentsApi.createPayin$lambda$1(this, idPayin, payin));
    }

    public final void setPayinExternalReference(@NotNull String idPayin, @NotNull String reference) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        ResponseExceptionUtils.INSTANCE.wrap(ClientErrorExceptionFactory.Companion.getInstance(), () -> IncomingPaymentsApi.setPayinExternalReference$lambda$2(this, idPayin, reference));
    }

    @NotNull
    public final PayinDetail getPayin(@NotNull String idPayin) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        return (PayinDetail)ResponseExceptionUtils.INSTANCE.wrap(GetPayinErrorExceptionFactory.Companion.getInstance(), () -> IncomingPaymentsApi.getPayin$lambda$3(this, idPayin));
    }

    @NotNull
    public final PaymentAccountDetail getPayinAccounts(@NotNull String idPayin) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        return (PaymentAccountDetail)ResponseExceptionUtils.INSTANCE.wrap(GetPayinErrorExceptionFactory.Companion.getInstance(), () -> IncomingPaymentsApi.getPayinAccounts$lambda$4(this, idPayin));
    }

    @NotNull
    public final AvailableTopUpOptions topupAvailablePaymentOptions(@NotNull TopUpRequested topUpRequested) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)topUpRequested, (String)"topUpRequested");
        return (AvailableTopUpOptions)ResponseExceptionUtils.INSTANCE.wrap(PostAvailableTopUpOptionsErrorExceptionFactory.Companion.getInstance(), () -> IncomingPaymentsApi.topupAvailablePaymentOptions$lambda$5(this, topUpRequested));
    }

    @NotNull
    public final TopUpAcceptedResponse createTopup(@NotNull String idTopUp, @NotNull TopUp topUp) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)idTopUp, (String)"idTopUp");
        Intrinsics.checkNotNullParameter((Object)topUp, (String)"topUp");
        return (TopUpAcceptedResponse)ResponseExceptionUtils.INSTANCE.wrap(PostPayinsErrorExceptionFactory.Companion.getInstance(), () -> IncomingPaymentsApi.createTopup$lambda$6(this, idTopUp, topUp));
    }

    @NotNull
    public final TopUpDetail getTopup(@NotNull String idTopUp) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)idTopUp, (String)"idTopUp");
        return (TopUpDetail)ResponseExceptionUtils.INSTANCE.wrap(GetTopupErrorExceptionFactory.Companion.getInstance(), () -> IncomingPaymentsApi.getTopup$lambda$7(this, idTopUp));
    }

    private static final AvailablePayinOptionList payinAvailablePaymentOptions$lambda$0(IncomingPaymentsApi this$0, PaymentRequested $paymentRequested) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$paymentRequested, (String)"$paymentRequested");
        return this$0.api.payinAvailablePaymentOptions(this$0.apiVersion, $paymentRequested);
    }

    private static final PayinAcceptedResponse createPayin$lambda$1(IncomingPaymentsApi this$0, String $idPayin, Payin $payin) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$idPayin, (String)"$idPayin");
        Intrinsics.checkNotNullParameter((Object)$payin, (String)"$payin");
        return this$0.api.createPayin(this$0.apiVersion, $idPayin, $payin);
    }

    private static final Unit setPayinExternalReference$lambda$2(IncomingPaymentsApi this$0, String $idPayin, String $reference) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$idPayin, (String)"$idPayin");
        Intrinsics.checkNotNullParameter((Object)$reference, (String)"$reference");
        EnhancedIncomingPaymentsApi enhancedIncomingPaymentsApi = this$0.api;
        int n = this$0.apiVersion;
        ExternalReference externalReference = ExternalReference.ofReference($reference);
        Intrinsics.checkNotNullExpressionValue((Object)externalReference, (String)"ofReference(...)");
        enhancedIncomingPaymentsApi.payinSetExternalReference(n, $idPayin, externalReference);
        return Unit.INSTANCE;
    }

    private static final PayinDetail getPayin$lambda$3(IncomingPaymentsApi this$0, String $idPayin) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$idPayin, (String)"$idPayin");
        return this$0.api.getPayin(this$0.apiVersion, $idPayin);
    }

    private static final PaymentAccountDetail getPayinAccounts$lambda$4(IncomingPaymentsApi this$0, String $idPayin) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$idPayin, (String)"$idPayin");
        return this$0.api.payinAccounts(this$0.apiVersion, $idPayin);
    }

    private static final AvailableTopUpOptions topupAvailablePaymentOptions$lambda$5(IncomingPaymentsApi this$0, TopUpRequested $topUpRequested) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$topUpRequested, (String)"$topUpRequested");
        return this$0.api.topupAvailablePaymentOptions(this$0.apiVersion, $topUpRequested);
    }

    private static final TopUpAcceptedResponse createTopup$lambda$6(IncomingPaymentsApi this$0, String $idTopUp, TopUp $topUp) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$idTopUp, (String)"$idTopUp");
        Intrinsics.checkNotNullParameter((Object)$topUp, (String)"$topUp");
        return this$0.api.createTopup(this$0.apiVersion, $idTopUp, $topUp);
    }

    private static final TopUpDetail getTopup$lambda$7(IncomingPaymentsApi this$0, String $idTopUp) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$idTopUp, (String)"$idTopUp");
        return this$0.api.getTopup(this$0.apiVersion, $idTopUp);
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition definePayinAvailablePaymentOptionsEndpoint() {
        return Factory.definePayinAvailablePaymentOptionsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineCreatePayinEndpoint() {
        return Factory.defineCreatePayinEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineSetPayinExternalReferenceEndpoint() {
        return Factory.defineSetPayinExternalReferenceEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineGetPayinEndpoint() {
        return Factory.defineGetPayinEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineGetPayinAccountsEndpoint() {
        return Factory.defineGetPayinAccountsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineTopUpAvailablePaymentOptionsEndpoint() {
        return Factory.defineTopUpAvailablePaymentOptionsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineCreateTopUpEndpoint() {
        return Factory.defineCreateTopUpEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineGetTopUpEndpoint() {
        return Factory.defineGetTopUpEndpoint();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
        return Factory.create(context, accessToken, callTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
        return Factory.create(context, accessToken);
    }

    public /* synthetic */ IncomingPaymentsApi(int apiVersion, EnhancedIncomingPaymentsApi api, DefaultConstructorMarker $constructor_marker) {
        this(apiVersion, api);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007J\b\u0010\t\u001a\u00020\u0007H\u0007J\b\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0007J\b\u0010\f\u001a\u00020\u0007H\u0007J\b\u0010\r\u001a\u00020\u0007H\u0007J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007\u00a8\u0006\u0016"}, d2={"Ltech/carpentum/sdk/payment/IncomingPaymentsApi$Factory;", "", "<init>", "()V", "definePayinAvailablePaymentOptionsEndpoint", "Ltech/carpentum/sdk/payment/EndpointDefinition;", "defineCreatePayinEndpoint", "Ltech/carpentum/sdk/payment/EndpointWithIdDefinition;", "defineSetPayinExternalReferenceEndpoint", "defineGetPayinEndpoint", "defineGetPayinAccountsEndpoint", "defineTopUpAvailablePaymentOptionsEndpoint", "defineCreateTopUpEndpoint", "defineGetTopUpEndpoint", "create", "Ltech/carpentum/sdk/payment/IncomingPaymentsApi;", "context", "Ltech/carpentum/sdk/payment/PaymentContext;", "accessToken", "", "callTimeout", "Ljava/time/Duration;", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition definePayinAvailablePaymentOptionsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.POST, "/payins/!availablePaymentOptions");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineCreatePayinEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.POST, "/payins/{id}");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineSetPayinExternalReferenceEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.POST, "/payins/{id}/!setExternalReference");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineGetPayinEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.GET, "/payins/{id}");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineGetPayinAccountsEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.GET, "/payins/{id}/accounts");
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineTopUpAvailablePaymentOptionsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.POST, "/topups/!availablePaymentOptions");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineCreateTopUpEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.POST, "/topups/{id}");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineGetTopUpEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.GET, "/topups/{id}");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            int n = context.getApiVersion();
            String string = context.getApiBaseUrl();
            String string2 = context.getBrand();
            Duration duration = callTimeout;
            if (duration == null) {
                duration = context.getDefaultCallTimeout();
            }
            return new IncomingPaymentsApi(n, new EnhancedIncomingPaymentsApi(string, accessToken, string2, duration), null);
        }

        public static /* synthetic */ IncomingPaymentsApi create$default(Factory factory, PaymentContext paymentContext, String string, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                duration = null;
            }
            return factory.create(paymentContext, string, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return tech.carpentum.sdk.payment.IncomingPaymentsApi$Factory.create$default(this, context, accessToken, null, 4, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

