/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseVaPay;
import tech.carpentum.sdk.payment.model.AccountResponseWithBank;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentInstruction;
import tech.carpentum.sdk.payment.model.SelectedPaymentOperatorIncoming;
import tech.carpentum.sdk.payment.model.VaPayMethodResponse;

@JsonClass(generateAdapter=false)
public class VaPayMethodResponseImpl
implements VaPayMethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final AccountResponseWithBank account;
    private final AccountCustomerResponseVaPay accountCustomer;
    private final MoneyPaymentResponse money;
    private final Optional<MoneyVat> vat;
    private final String reference;
    private final String returnUrl;
    private final Optional<SelectedPaymentOperatorIncoming> paymentOperator;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final List<@NotNull PaymentInstruction> paymentInstructionList;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public AccountResponseWithBank getAccount() {
        return this.account;
    }

    @Override
    public AccountCustomerResponseVaPay getAccountCustomer() {
        return this.accountCustomer;
    }

    @Override
    public MoneyPaymentResponse getMoney() {
        return this.money;
    }

    @Override
    public Optional<MoneyVat> getVat() {
        return this.vat;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public Optional<SelectedPaymentOperatorIncoming> getPaymentOperator() {
        return this.paymentOperator;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public List<@NotNull PaymentInstruction> getPaymentInstructionList() {
        return this.paymentInstructionList;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private VaPayMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.accountCustomer = Objects.requireNonNull(builder.accountCustomer, "Property 'accountCustomer' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.vat = Optional.ofNullable(builder.vat);
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.paymentOperator = Optional.ofNullable(builder.paymentOperator);
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.paymentInstructionList = Collections.unmodifiableList(builder.paymentInstructionList);
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.account, this.accountCustomer, this.money, this.vat, this.reference, this.returnUrl, this.paymentOperator, this.acceptedAt, this.expireAt, this.paymentInstructionList);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", account=" + this.account + ", accountCustomer=" + this.accountCustomer + ", money=" + this.money + ", vat=" + this.vat + ", reference=" + this.reference + ", returnUrl=" + this.returnUrl + ", paymentOperator=" + this.paymentOperator + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ", paymentInstructionList=" + this.paymentInstructionList + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VaPayMethodResponseImpl)) {
            return false;
        }
        VaPayMethodResponseImpl that = (VaPayMethodResponseImpl)obj;
        if (!Objects.equals(this.idPayin, that.idPayin)) {
            return false;
        }
        if (!Objects.equals(this.idPayment, that.idPayment)) {
            return false;
        }
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.accountCustomer, that.accountCustomer)) {
            return false;
        }
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.vat, that.vat)) {
            return false;
        }
        if (!Objects.equals(this.reference, that.reference)) {
            return false;
        }
        if (!Objects.equals(this.returnUrl, that.returnUrl)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperator, that.paymentOperator)) {
            return false;
        }
        if (!Objects.equals(this.acceptedAt, that.acceptedAt)) {
            return false;
        }
        if (!Objects.equals(this.expireAt, that.expireAt)) {
            return false;
        }
        return Objects.equals(this.paymentInstructionList, that.paymentInstructionList);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements VaPayMethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private AccountResponseWithBank account = null;
        private AccountCustomerResponseVaPay accountCustomer = null;
        private MoneyPaymentResponse money = null;
        private MoneyVat vat = null;
        private String reference = null;
        private String returnUrl = null;
        private SelectedPaymentOperatorIncoming paymentOperator = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private List<@NotNull PaymentInstruction> paymentInstructionList = new ArrayList<PaymentInstruction>();
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("VaPayMethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public boolean isIdPayinDefined() {
            return this.idPayin != null;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public boolean isIdPaymentDefined() {
            return this.idPayment != null;
        }

        @Override
        public BuilderImpl account(AccountResponseWithBank account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl accountCustomer(AccountCustomerResponseVaPay accountCustomer) {
            this.accountCustomer = accountCustomer;
            return this;
        }

        @Override
        public boolean isAccountCustomerDefined() {
            return this.accountCustomer != null;
        }

        @Override
        public BuilderImpl money(MoneyPaymentResponse money) {
            this.money = money;
            return this;
        }

        @Override
        public boolean isMoneyDefined() {
            return this.money != null;
        }

        @Override
        public BuilderImpl vat(MoneyVat vat) {
            this.vat = vat;
            return this;
        }

        @Override
        public boolean isVatDefined() {
            return this.vat != null;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public boolean isReferenceDefined() {
            return this.reference != null;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public boolean isReturnUrlDefined() {
            return this.returnUrl != null;
        }

        @Override
        public BuilderImpl paymentOperator(SelectedPaymentOperatorIncoming paymentOperator) {
            this.paymentOperator = paymentOperator;
            return this;
        }

        @Override
        public boolean isPaymentOperatorDefined() {
            return this.paymentOperator != null;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public boolean isAcceptedAtDefined() {
            return this.acceptedAt != null;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public boolean isExpireAtDefined() {
            return this.expireAt != null;
        }

        @Override
        public BuilderImpl paymentInstructionList(List<@NotNull PaymentInstruction> paymentInstructionList) {
            this.paymentInstructionList.clear();
            if (paymentInstructionList != null) {
                this.paymentInstructionList.addAll(paymentInstructionList);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentInstructionListAdd(PaymentInstruction item) {
            if (item != null) {
                this.paymentInstructionList.add(item);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentInstructionListAddAll(List<@NotNull PaymentInstruction> paymentInstructionList) {
            if (paymentInstructionList != null) {
                this.paymentInstructionList.addAll(paymentInstructionList);
            }
            return this;
        }

        @Override
        public VaPayMethodResponseImpl build() {
            return new VaPayMethodResponseImpl(this);
        }
    }
}

