/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountCustomerResponsePixQR;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PixQRMethodResponse;

@JsonClass(generateAdapter=false)
public class PixQRMethodResponseImpl
implements PixQRMethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final MoneyPaymentResponse money;
    private final Optional<MoneyVat> vat;
    private final String merchantName;
    private final String qrName;
    private final String qrCode;
    private final String qrEmv;
    private final AccountCustomerResponsePixQR accountCustomer;
    private final String taxId;
    private final String reference;
    private final String returnUrl;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public MoneyPaymentResponse getMoney() {
        return this.money;
    }

    @Override
    public Optional<MoneyVat> getVat() {
        return this.vat;
    }

    @Override
    public String getMerchantName() {
        return this.merchantName;
    }

    @Override
    public String getQrName() {
        return this.qrName;
    }

    @Override
    public String getQrCode() {
        return this.qrCode;
    }

    @Override
    public String getQrEmv() {
        return this.qrEmv;
    }

    @Override
    public AccountCustomerResponsePixQR getAccountCustomer() {
        return this.accountCustomer;
    }

    @Override
    public String getTaxId() {
        return this.taxId;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private PixQRMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.vat = Optional.ofNullable(builder.vat);
        this.merchantName = Objects.requireNonNull(builder.merchantName, "Property 'merchantName' is required.");
        this.qrName = Objects.requireNonNull(builder.qrName, "Property 'qrName' is required.");
        this.qrCode = Objects.requireNonNull(builder.qrCode, "Property 'qrCode' is required.");
        this.qrEmv = Objects.requireNonNull(builder.qrEmv, "Property 'qrEmv' is required.");
        this.accountCustomer = Objects.requireNonNull(builder.accountCustomer, "Property 'accountCustomer' is required.");
        this.taxId = Objects.requireNonNull(builder.taxId, "Property 'taxId' is required.");
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.money, this.vat, this.merchantName, this.qrName, this.qrCode, this.qrEmv, this.accountCustomer, this.taxId, this.reference, this.returnUrl, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", money=" + this.money + ", vat=" + this.vat + ", merchantName=" + this.merchantName + ", qrName=" + this.qrName + ", qrCode=" + this.qrCode + ", qrEmv=" + this.qrEmv + ", accountCustomer=" + this.accountCustomer + ", taxId=" + this.taxId + ", reference=" + this.reference + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PixQRMethodResponseImpl)) {
            return false;
        }
        PixQRMethodResponseImpl that = (PixQRMethodResponseImpl)obj;
        if (!Objects.equals(this.idPayin, that.idPayin)) {
            return false;
        }
        if (!Objects.equals(this.idPayment, that.idPayment)) {
            return false;
        }
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.vat, that.vat)) {
            return false;
        }
        if (!Objects.equals(this.merchantName, that.merchantName)) {
            return false;
        }
        if (!Objects.equals(this.qrName, that.qrName)) {
            return false;
        }
        if (!Objects.equals(this.qrCode, that.qrCode)) {
            return false;
        }
        if (!Objects.equals(this.qrEmv, that.qrEmv)) {
            return false;
        }
        if (!Objects.equals(this.accountCustomer, that.accountCustomer)) {
            return false;
        }
        if (!Objects.equals(this.taxId, that.taxId)) {
            return false;
        }
        if (!Objects.equals(this.reference, that.reference)) {
            return false;
        }
        if (!Objects.equals(this.returnUrl, that.returnUrl)) {
            return false;
        }
        if (!Objects.equals(this.acceptedAt, that.acceptedAt)) {
            return false;
        }
        return Objects.equals(this.expireAt, that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PixQRMethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private MoneyPaymentResponse money = null;
        private MoneyVat vat = null;
        private String merchantName = null;
        private String qrName = null;
        private String qrCode = null;
        private String qrEmv = null;
        private AccountCustomerResponsePixQR accountCustomer = null;
        private String taxId = null;
        private String reference = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PixQRMethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public boolean isIdPayinDefined() {
            return this.idPayin != null;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public boolean isIdPaymentDefined() {
            return this.idPayment != null;
        }

        @Override
        public BuilderImpl money(MoneyPaymentResponse money) {
            this.money = money;
            return this;
        }

        @Override
        public boolean isMoneyDefined() {
            return this.money != null;
        }

        @Override
        public BuilderImpl vat(MoneyVat vat) {
            this.vat = vat;
            return this;
        }

        @Override
        public boolean isVatDefined() {
            return this.vat != null;
        }

        @Override
        public BuilderImpl merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @Override
        public boolean isMerchantNameDefined() {
            return this.merchantName != null;
        }

        @Override
        public BuilderImpl qrName(String qrName) {
            this.qrName = qrName;
            return this;
        }

        @Override
        public boolean isQrNameDefined() {
            return this.qrName != null;
        }

        @Override
        public BuilderImpl qrCode(String qrCode) {
            this.qrCode = qrCode;
            return this;
        }

        @Override
        public boolean isQrCodeDefined() {
            return this.qrCode != null;
        }

        @Override
        public BuilderImpl qrEmv(String qrEmv) {
            this.qrEmv = qrEmv;
            return this;
        }

        @Override
        public boolean isQrEmvDefined() {
            return this.qrEmv != null;
        }

        @Override
        public BuilderImpl accountCustomer(AccountCustomerResponsePixQR accountCustomer) {
            this.accountCustomer = accountCustomer;
            return this;
        }

        @Override
        public boolean isAccountCustomerDefined() {
            return this.accountCustomer != null;
        }

        @Override
        public BuilderImpl taxId(String taxId) {
            this.taxId = taxId;
            return this;
        }

        @Override
        public boolean isTaxIdDefined() {
            return this.taxId != null;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public boolean isReferenceDefined() {
            return this.reference != null;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public boolean isReturnUrlDefined() {
            return this.returnUrl != null;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public boolean isAcceptedAtDefined() {
            return this.acceptedAt != null;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public boolean isExpireAtDefined() {
            return this.expireAt != null;
        }

        @Override
        public PixQRMethodResponseImpl build() {
            return new PixQRMethodResponseImpl(this);
        }
    }
}

