/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PayShapMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestPayShap;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface PayShapMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.PAYSHAP;

    @NotNull
    public Optional<AccountPayinRequestPayShap> getAccount();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public String getPaymentOperatorCode();

    @NotNull
    public Optional<String> getExternalProviderCode();

    @NotNull
    public static Builder builder(PayShapMethod copyOf) {
        Builder builder = PayShapMethod.builder();
        builder.account(copyOf.getAccount().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode());
        builder.externalProviderCode(copyOf.getExternalProviderCode().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PayShapMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestPayShap var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public Builder externalProviderCode(String var1);

        public boolean isExternalProviderCodeDefined();

        @NotNull
        public PayShapMethod build();
    }
}

