/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestVaPayVerif;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.VaPayVerifMethod;

@JsonClass(generateAdapter=false)
public class VaPayVerifMethodImpl
implements VaPayVerifMethod {
    private final AccountPayinRequestVaPayVerif account;
    private final String paymentOperatorCode;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    public AccountPayinRequestVaPayVerif getAccount() {
        return this.account;
    }

    @Override
    public String getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private VaPayVerifMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.paymentOperatorCode = Objects.requireNonNull(builder.paymentOperatorCode, "Property 'paymentOperatorCode' is required.");
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.account, this.paymentOperatorCode, this.emailAddress);
        this.toString = builder.type + "(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", emailAddress=" + this.emailAddress + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VaPayVerifMethodImpl)) {
            return false;
        }
        VaPayVerifMethodImpl that = (VaPayVerifMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperatorCode, that.paymentOperatorCode)) {
            return false;
        }
        return Objects.equals(this.emailAddress, that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements VaPayVerifMethod.Builder {
        private AccountPayinRequestVaPayVerif account = null;
        private String paymentOperatorCode = null;
        private String emailAddress = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("VaPayVerifMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestVaPayVerif account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public boolean isPaymentOperatorCodeDefined() {
            return this.paymentOperatorCode != null;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public VaPayVerifMethodImpl build() {
            return new VaPayVerifMethodImpl(this);
        }
    }
}

