/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.Redirection;

@JsonClass(generateAdapter=false)
public class RedirectionImpl
implements Redirection {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private final String method;
    private final String url;
    private final Optional<String> data;
    private final int hashCode;
    private final String toString;

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Optional<String> getData() {
        return this.data;
    }

    private RedirectionImpl(BuilderImpl builder) {
        this.method = Objects.requireNonNull(builder.method, "Property 'method' is required.");
        this.url = Objects.requireNonNull(builder.url, "Property 'url' is required.");
        this.data = Optional.ofNullable(builder.data);
        this.hashCode = Objects.hash(this.method, this.url, this.data);
        this.toString = builder.type + "(method=" + this.method + ", url=" + this.url + ", data=" + this.data + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedirectionImpl)) {
            return false;
        }
        RedirectionImpl that = (RedirectionImpl)obj;
        if (!Objects.equals(this.method, that.method)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.data, that.data);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements Redirection.Builder {
        private String method = null;
        private String url = null;
        private String data = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("Redirection");
        }

        @Override
        public BuilderImpl method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public boolean isMethodDefined() {
            return this.method != null;
        }

        @Override
        public BuilderImpl url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public boolean isUrlDefined() {
            return this.url != null;
        }

        @Override
        public BuilderImpl data(String data) {
            this.data = data;
            return this;
        }

        @Override
        public boolean isDataDefined() {
            return this.data != null;
        }

        @Override
        public RedirectionImpl build() {
            return new RedirectionImpl(this);
        }
    }
}

