/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.Payout;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public class PayoutImpl
implements Payout {
    private final PaymentRequested paymentRequested;
    private final PayoutMethod paymentMethod;
    private final Optional<String> callbackUrl;
    private final Optional<String> customerIp;
    private final int hashCode;
    private final String toString;

    @Override
    public PaymentRequested getPaymentRequested() {
        return this.paymentRequested;
    }

    @Override
    public PayoutMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @Override
    public Optional<String> getCallbackUrl() {
        return this.callbackUrl;
    }

    @Override
    public Optional<String> getCustomerIp() {
        return this.customerIp;
    }

    private PayoutImpl(BuilderImpl builder) {
        this.paymentRequested = Objects.requireNonNull(builder.paymentRequested, "Property 'paymentRequested' is required.");
        this.paymentMethod = Objects.requireNonNull(builder.paymentMethod, "Property 'paymentMethod' is required.");
        this.callbackUrl = Optional.ofNullable(builder.callbackUrl);
        this.customerIp = Optional.ofNullable(builder.customerIp);
        this.hashCode = Objects.hash(this.paymentRequested, this.paymentMethod, this.callbackUrl, this.customerIp);
        this.toString = builder.type + "(paymentRequested=" + this.paymentRequested + ", paymentMethod=" + this.paymentMethod + ", callbackUrl=" + this.callbackUrl + ", customerIp=" + this.customerIp + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayoutImpl)) {
            return false;
        }
        PayoutImpl that = (PayoutImpl)obj;
        if (!Objects.equals(this.paymentRequested, that.paymentRequested)) {
            return false;
        }
        if (!Objects.equals(this.paymentMethod, that.paymentMethod)) {
            return false;
        }
        if (!Objects.equals(this.callbackUrl, that.callbackUrl)) {
            return false;
        }
        return Objects.equals(this.customerIp, that.customerIp);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements Payout.Builder {
        private PaymentRequested paymentRequested = null;
        private PayoutMethod paymentMethod = null;
        private String callbackUrl = null;
        private String customerIp = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("Payout");
        }

        @Override
        public BuilderImpl paymentRequested(PaymentRequested paymentRequested) {
            this.paymentRequested = paymentRequested;
            return this;
        }

        @Override
        public boolean isPaymentRequestedDefined() {
            return this.paymentRequested != null;
        }

        @Override
        public BuilderImpl paymentMethod(PayoutMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        @Override
        public boolean isPaymentMethodDefined() {
            return this.paymentMethod != null;
        }

        @Override
        public BuilderImpl callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        @Override
        public boolean isCallbackUrlDefined() {
            return this.callbackUrl != null;
        }

        @Override
        public BuilderImpl customerIp(String customerIp) {
            this.customerIp = customerIp;
            return this;
        }

        @Override
        public boolean isCustomerIpDefined() {
            return this.customerIp != null;
        }

        @Override
        public PayoutImpl build() {
            return new PayoutImpl(this);
        }
    }
}

