/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.CustomerTransactionFee;
import tech.carpentum.sdk.payment.model.PaymentOperatorOutgoing;

@JsonClass(generateAdapter=false)
public class PaymentOperatorOutgoingImpl
implements PaymentOperatorOutgoing {
    private final String code;
    private final String name;
    private final Optional<CustomerTransactionFee> customerTransactionFee;
    private final int hashCode;
    private final String toString;

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<CustomerTransactionFee> getCustomerTransactionFee() {
        return this.customerTransactionFee;
    }

    private PaymentOperatorOutgoingImpl(BuilderImpl builder) {
        this.code = Objects.requireNonNull(builder.code, "Property 'code' is required.");
        this.name = Objects.requireNonNull(builder.name, "Property 'name' is required.");
        this.customerTransactionFee = Optional.ofNullable(builder.customerTransactionFee);
        this.hashCode = Objects.hash(this.code, this.name, this.customerTransactionFee);
        this.toString = builder.type + "(code=" + this.code + ", name=" + this.name + ", customerTransactionFee=" + this.customerTransactionFee + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentOperatorOutgoingImpl)) {
            return false;
        }
        PaymentOperatorOutgoingImpl that = (PaymentOperatorOutgoingImpl)obj;
        if (!Objects.equals(this.code, that.code)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.customerTransactionFee, that.customerTransactionFee);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PaymentOperatorOutgoing.Builder {
        private String code = null;
        private String name = null;
        private CustomerTransactionFee customerTransactionFee = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PaymentOperatorOutgoing");
        }

        @Override
        public BuilderImpl code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public boolean isCodeDefined() {
            return this.code != null;
        }

        @Override
        public BuilderImpl name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public boolean isNameDefined() {
            return this.name != null;
        }

        @Override
        public BuilderImpl customerTransactionFee(CustomerTransactionFee customerTransactionFee) {
            this.customerTransactionFee = customerTransactionFee;
            return this;
        }

        @Override
        public boolean isCustomerTransactionFeeDefined() {
            return this.customerTransactionFee != null;
        }

        @Override
        public PaymentOperatorOutgoingImpl build() {
            return new PaymentOperatorOutgoingImpl(this);
        }
    }
}

