/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.QrisPayMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestQrisPay;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface QrisPayMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.QRISPAY;

    @NotNull
    public Optional<AccountPayinRequestQrisPay> getAccount();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public static Builder builder(QrisPayMethod copyOf) {
        Builder builder = QrisPayMethod.builder();
        builder.account(copyOf.getAccount().orElse(null));
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new QrisPayMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestQrisPay var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public QrisPayMethod build();
    }
}

