/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AbsaPayMethod;
import tech.carpentum.sdk.payment.model.AccountPayinRequestAbsaPay;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class AbsaPayMethodImpl
implements AbsaPayMethod {
    private final AccountPayinRequestAbsaPay account;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    public AccountPayinRequestAbsaPay getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private AbsaPayMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.account, this.emailAddress);
        this.toString = builder.type + "(account=" + this.account + ", emailAddress=" + this.emailAddress + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbsaPayMethodImpl)) {
            return false;
        }
        AbsaPayMethodImpl that = (AbsaPayMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        return Objects.equals(this.emailAddress, that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AbsaPayMethod.Builder {
        private AccountPayinRequestAbsaPay account = null;
        private String emailAddress = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AbsaPayMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestAbsaPay account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public AbsaPayMethodImpl build() {
            return new AbsaPayMethodImpl(this);
        }
    }
}

