/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.VietQRMethod;

@JsonClass(generateAdapter=false)
public class VietQRMethodImpl
implements VietQRMethod {
    private final String paymentOperatorCode;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    public String getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private VietQRMethodImpl(BuilderImpl builder) {
        this.paymentOperatorCode = Objects.requireNonNull(builder.paymentOperatorCode, "Property 'paymentOperatorCode' is required.");
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.paymentOperatorCode, this.emailAddress);
        this.toString = builder.type + "(paymentOperatorCode=" + this.paymentOperatorCode + ", emailAddress=" + this.emailAddress + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VietQRMethodImpl)) {
            return false;
        }
        VietQRMethodImpl that = (VietQRMethodImpl)obj;
        if (!Objects.equals(this.paymentOperatorCode, that.paymentOperatorCode)) {
            return false;
        }
        return Objects.equals(this.emailAddress, that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements VietQRMethod.Builder {
        private String paymentOperatorCode = null;
        private String emailAddress = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("VietQRMethod");
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public VietQRMethodImpl build() {
            return new VietQRMethodImpl(this);
        }
    }
}

