/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.TopUp;
import tech.carpentum.sdk.payment.model.TopUpRequested;

@JsonClass(generateAdapter=false)
public class TopUpImpl
implements TopUp {
    private final TopUpRequested topUpRequested;
    private final PayinMethod paymentMethod;
    private final Optional<String> callbackUrl;
    private final String returnUrl;
    private final Optional<String> customerIp;
    private final int hashCode;
    private final String toString;

    @Override
    public TopUpRequested getTopUpRequested() {
        return this.topUpRequested;
    }

    @Override
    public PayinMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @Override
    public Optional<String> getCallbackUrl() {
        return this.callbackUrl;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public Optional<String> getCustomerIp() {
        return this.customerIp;
    }

    private TopUpImpl(BuilderImpl builder) {
        this.topUpRequested = Objects.requireNonNull(builder.topUpRequested, "Property 'topUpRequested' is required.");
        this.paymentMethod = Objects.requireNonNull(builder.paymentMethod, "Property 'paymentMethod' is required.");
        this.callbackUrl = Optional.ofNullable(builder.callbackUrl);
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.customerIp = Optional.ofNullable(builder.customerIp);
        this.hashCode = Objects.hash(this.topUpRequested, this.paymentMethod, this.callbackUrl, this.returnUrl, this.customerIp);
        this.toString = builder.type + "(topUpRequested=" + this.topUpRequested + ", paymentMethod=" + this.paymentMethod + ", callbackUrl=" + this.callbackUrl + ", returnUrl=" + this.returnUrl + ", customerIp=" + this.customerIp + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopUpImpl)) {
            return false;
        }
        TopUpImpl that = (TopUpImpl)obj;
        if (!Objects.equals(this.topUpRequested, that.topUpRequested)) {
            return false;
        }
        if (!Objects.equals(this.paymentMethod, that.paymentMethod)) {
            return false;
        }
        if (!Objects.equals(this.callbackUrl, that.callbackUrl)) {
            return false;
        }
        if (!Objects.equals(this.returnUrl, that.returnUrl)) {
            return false;
        }
        return Objects.equals(this.customerIp, that.customerIp);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements TopUp.Builder {
        private TopUpRequested topUpRequested = null;
        private PayinMethod paymentMethod = null;
        private String callbackUrl = null;
        private String returnUrl = null;
        private String customerIp = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("TopUp");
        }

        @Override
        public BuilderImpl topUpRequested(TopUpRequested topUpRequested) {
            this.topUpRequested = topUpRequested;
            return this;
        }

        @Override
        public BuilderImpl paymentMethod(PayinMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        @Override
        public BuilderImpl callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public BuilderImpl customerIp(String customerIp) {
            this.customerIp = customerIp;
            return this;
        }

        @Override
        public TopUpImpl build() {
            return new TopUpImpl(this);
        }
    }
}

