/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AuthTokenRequest;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.SettlementMethod;

@JsonClass(generateAdapter=false)
public class AuthTokenRequestImpl
implements AuthTokenRequest {
    private final String merchantCode;
    private final String secret;
    private final Optional<Integer> validitySecs;
    private final List<@NotNull String> operations;
    private final Optional<Money> money;
    private final Optional<Money> moneyProvided;
    private final Optional<CurrencyCode> currencyCodeRequired;
    private final Optional<Money> moneyRequired;
    private final Optional<CurrencyCode> currencyCodeProvided;
    private final Optional<SettlementMethod> settlementMethod;
    private final int hashCode;
    private final String toString;

    @Override
    public String getMerchantCode() {
        return this.merchantCode;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public Optional<Integer> getValiditySecs() {
        return this.validitySecs;
    }

    @Override
    public List<@NotNull String> getOperations() {
        return this.operations;
    }

    @Override
    public Optional<Money> getMoney() {
        return this.money;
    }

    @Override
    public Optional<Money> getMoneyProvided() {
        return this.moneyProvided;
    }

    @Override
    public Optional<CurrencyCode> getCurrencyCodeRequired() {
        return this.currencyCodeRequired;
    }

    @Override
    public Optional<Money> getMoneyRequired() {
        return this.moneyRequired;
    }

    @Override
    public Optional<CurrencyCode> getCurrencyCodeProvided() {
        return this.currencyCodeProvided;
    }

    @Override
    public Optional<SettlementMethod> getSettlementMethod() {
        return this.settlementMethod;
    }

    private AuthTokenRequestImpl(BuilderImpl builder) {
        this.merchantCode = Objects.requireNonNull(builder.merchantCode, "Property 'merchantCode' is required.");
        this.secret = Objects.requireNonNull(builder.secret, "Property 'secret' is required.");
        this.validitySecs = Optional.ofNullable(builder.validitySecs);
        this.operations = Collections.unmodifiableList(builder.operations);
        this.money = Optional.ofNullable(builder.money);
        this.moneyProvided = Optional.ofNullable(builder.moneyProvided);
        this.currencyCodeRequired = Optional.ofNullable(builder.currencyCodeRequired);
        this.moneyRequired = Optional.ofNullable(builder.moneyRequired);
        this.currencyCodeProvided = Optional.ofNullable(builder.currencyCodeProvided);
        this.settlementMethod = Optional.ofNullable(builder.settlementMethod);
        this.hashCode = Objects.hash(this.merchantCode, this.secret, this.validitySecs, this.operations, this.money, this.moneyProvided, this.currencyCodeRequired, this.moneyRequired, this.currencyCodeProvided, this.settlementMethod);
        this.toString = builder.type + "(merchantCode=" + this.merchantCode + ", secret=" + this.secret + ", validitySecs=" + this.validitySecs + ", operations=" + this.operations + ", money=" + this.money + ", moneyProvided=" + this.moneyProvided + ", currencyCodeRequired=" + this.currencyCodeRequired + ", moneyRequired=" + this.moneyRequired + ", currencyCodeProvided=" + this.currencyCodeProvided + ", settlementMethod=" + this.settlementMethod + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthTokenRequestImpl)) {
            return false;
        }
        AuthTokenRequestImpl that = (AuthTokenRequestImpl)obj;
        if (!Objects.equals(this.merchantCode, that.merchantCode)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        if (!Objects.equals(this.validitySecs, that.validitySecs)) {
            return false;
        }
        if (!Objects.equals(this.operations, that.operations)) {
            return false;
        }
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.moneyProvided, that.moneyProvided)) {
            return false;
        }
        if (!Objects.equals(this.currencyCodeRequired, that.currencyCodeRequired)) {
            return false;
        }
        if (!Objects.equals(this.moneyRequired, that.moneyRequired)) {
            return false;
        }
        if (!Objects.equals(this.currencyCodeProvided, that.currencyCodeProvided)) {
            return false;
        }
        return Objects.equals(this.settlementMethod, that.settlementMethod);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AuthTokenRequest.Builder {
        private String merchantCode = null;
        private String secret = null;
        private Integer validitySecs = null;
        private List<@NotNull String> operations = new ArrayList<String>();
        private Money money = null;
        private Money moneyProvided = null;
        private CurrencyCode currencyCodeRequired = null;
        private Money moneyRequired = null;
        private CurrencyCode currencyCodeProvided = null;
        private SettlementMethod settlementMethod = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AuthTokenRequest");
        }

        @Override
        public BuilderImpl merchantCode(String merchantCode) {
            this.merchantCode = merchantCode;
            return this;
        }

        @Override
        public BuilderImpl secret(String secret) {
            this.secret = secret;
            return this;
        }

        @Override
        public BuilderImpl validitySecs(Integer validitySecs) {
            this.validitySecs = validitySecs;
            return this;
        }

        @Override
        public BuilderImpl operations(List<@NotNull String> operations) {
            this.operations.clear();
            if (operations != null) {
                this.operations.addAll(operations);
            }
            return this;
        }

        @Override
        public BuilderImpl operationsAdd(String item) {
            if (item != null) {
                this.operations.add(item);
            }
            return this;
        }

        @Override
        public BuilderImpl operationsAddAll(List<@NotNull String> operations) {
            if (operations != null) {
                this.operations.addAll(operations);
            }
            return this;
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl moneyProvided(Money moneyProvided) {
            this.moneyProvided = moneyProvided;
            return this;
        }

        @Override
        public BuilderImpl currencyCodeRequired(CurrencyCode currencyCodeRequired) {
            this.currencyCodeRequired = currencyCodeRequired;
            return this;
        }

        @Override
        public BuilderImpl moneyRequired(Money moneyRequired) {
            this.moneyRequired = moneyRequired;
            return this;
        }

        @Override
        public BuilderImpl currencyCodeProvided(CurrencyCode currencyCodeProvided) {
            this.currencyCodeProvided = currencyCodeProvided;
            return this;
        }

        @Override
        public BuilderImpl settlementMethod(SettlementMethod settlementMethod) {
            this.settlementMethod = settlementMethod;
            return this;
        }

        @Override
        public AuthTokenRequestImpl build() {
            return new AuthTokenRequestImpl(this);
        }
    }
}

