/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestOffline;

@JsonClass(generateAdapter=false)
public class AccountPayinRequestOfflineImpl
implements AccountPayinRequestOffline {
    private final Optional<String> accountName;
    private final Optional<String> accountNumber;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<String> getAccountName() {
        return this.accountName;
    }

    @Override
    public Optional<String> getAccountNumber() {
        return this.accountNumber;
    }

    private AccountPayinRequestOfflineImpl(BuilderImpl builder) {
        this.accountName = Optional.ofNullable(builder.accountName);
        this.accountNumber = Optional.ofNullable(builder.accountNumber);
        this.hashCode = Objects.hash(this.accountName, this.accountNumber);
        this.toString = builder.type + "(accountName=" + this.accountName + ", accountNumber=" + this.accountNumber + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountPayinRequestOfflineImpl)) {
            return false;
        }
        AccountPayinRequestOfflineImpl that = (AccountPayinRequestOfflineImpl)obj;
        if (!Objects.equals(this.accountName, that.accountName)) {
            return false;
        }
        return Objects.equals(this.accountNumber, that.accountNumber);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AccountPayinRequestOffline.Builder {
        private String accountName = null;
        private String accountNumber = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AccountPayinRequestOffline");
        }

        @Override
        public BuilderImpl accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        @Override
        public BuilderImpl accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        @Override
        public AccountPayinRequestOfflineImpl build() {
            return new AccountPayinRequestOfflineImpl(this);
        }
    }
}

