/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.io.InterruptedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.EndpointDefinition;
import tech.carpentum.sdk.payment.PaymentContext;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.ClientErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.CommaSeparatedCodes;
import tech.carpentum.sdk.payment.internal.api.EnhancedPaymentsApi;
import tech.carpentum.sdk.payment.internal.api.GetPaymentOptionsErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.internal.generated.api.PaymentsApi;
import tech.carpentum.sdk.payment.model.CurrencyList;
import tech.carpentum.sdk.payment.model.PaymentMethodsList;
import tech.carpentum.sdk.payment.model.PaymentOperatorList;
import tech.carpentum.sdk.payment.model.PaymentOptionsList;
import tech.carpentum.sdk.payment.model.SegmentList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi;", "", "apiVersion", "", "api", "Ltech/carpentum/sdk/payment/internal/api/EnhancedPaymentsApi;", "<init>", "(ILtech/carpentum/sdk/payment/internal/api/EnhancedPaymentsApi;)V", "listCurrencies", "Ltech/carpentum/sdk/payment/model/CurrencyList;", "listSegments", "Ltech/carpentum/sdk/payment/model/SegmentList;", "listPaymentOperators", "Ltech/carpentum/sdk/payment/model/PaymentOperatorList;", "listPaymentMethods", "Ltech/carpentum/sdk/payment/model/PaymentMethodsList;", "listPaymentOptions", "Ltech/carpentum/sdk/payment/model/PaymentOptionsList;", "query", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery;", "Ljava/util/function/Supplier;", "ListPaymentOptionsQuery", "Factory", "payment-client-v2"})
public final class PaymentsApi {
    @NotNull
    public static final Factory Factory = new Factory(null);
    private final int apiVersion;
    @NotNull
    private final EnhancedPaymentsApi api;

    private PaymentsApi(int apiVersion, EnhancedPaymentsApi api) {
        this.apiVersion = apiVersion;
        this.api = api;
    }

    @NotNull
    public final CurrencyList listCurrencies() throws ResponseException, InterruptedIOException {
        return (CurrencyList)ResponseExceptionUtils.INSTANCE.wrap(ClientErrorExceptionFactory.Companion.getInstance(), () -> PaymentsApi.listCurrencies$lambda$0(this));
    }

    @NotNull
    public final SegmentList listSegments() throws ResponseException, InterruptedIOException {
        return (SegmentList)ResponseExceptionUtils.INSTANCE.wrap(ClientErrorExceptionFactory.Companion.getInstance(), () -> PaymentsApi.listSegments$lambda$1(this));
    }

    @NotNull
    public final PaymentOperatorList listPaymentOperators() throws ResponseException, InterruptedIOException {
        return (PaymentOperatorList)ResponseExceptionUtils.INSTANCE.wrap(ClientErrorExceptionFactory.Companion.getInstance(), () -> PaymentsApi.listPaymentOperators$lambda$2(this));
    }

    @NotNull
    public final PaymentMethodsList listPaymentMethods() throws ResponseException, InterruptedIOException {
        return (PaymentMethodsList)ResponseExceptionUtils.INSTANCE.wrap(ClientErrorExceptionFactory.Companion.getInstance(), () -> PaymentsApi.listPaymentMethods$lambda$3(this));
    }

    @JvmOverloads
    @NotNull
    public final PaymentOptionsList listPaymentOptions(@NotNull ListPaymentOptionsQuery query) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return (PaymentOptionsList)ResponseExceptionUtils.INSTANCE.wrap(GetPaymentOptionsErrorExceptionFactory.Companion.getInstance(), () -> PaymentsApi.listPaymentOptions$lambda$4(this, query));
    }

    public static /* synthetic */ PaymentOptionsList listPaymentOptions$default(PaymentsApi paymentsApi, ListPaymentOptionsQuery listPaymentOptionsQuery, int n, Object object) throws ResponseException, InterruptedIOException {
        if ((n & 1) != 0) {
            listPaymentOptionsQuery = ListPaymentOptionsQuery.Factory.any();
        }
        return paymentsApi.listPaymentOptions(listPaymentOptionsQuery);
    }

    @NotNull
    public final PaymentOptionsList listPaymentOptions(@NotNull Supplier<ListPaymentOptionsQuery> query) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        ListPaymentOptionsQuery listPaymentOptionsQuery = query.get();
        Intrinsics.checkNotNullExpressionValue((Object)listPaymentOptionsQuery, (String)"get(...)");
        return this.listPaymentOptions(listPaymentOptionsQuery);
    }

    @JvmOverloads
    @NotNull
    public final PaymentOptionsList listPaymentOptions() throws ResponseException, InterruptedIOException {
        return PaymentsApi.listPaymentOptions$default(this, null, 1, null);
    }

    private static final CurrencyList listCurrencies$lambda$0(PaymentsApi this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.api.getCurrencies(this$0.apiVersion);
    }

    private static final SegmentList listSegments$lambda$1(PaymentsApi this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.api.getSegments(this$0.apiVersion);
    }

    private static final PaymentOperatorList listPaymentOperators$lambda$2(PaymentsApi this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.api.getPaymentOperators(this$0.apiVersion);
    }

    private static final PaymentMethodsList listPaymentMethods$lambda$3(PaymentsApi this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.api.getPaymentMethods(this$0.apiVersion);
    }

    private static final PaymentOptionsList listPaymentOptions$lambda$4(PaymentsApi this$0, ListPaymentOptionsQuery $query) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
        ListPaymentOptionsQuery.PaymentTypeCode paymentTypeCode = $query.getPaymentTypeCode();
        return this$0.api.getPaymentOptions(this$0.apiVersion, paymentTypeCode != null ? paymentTypeCode.toModel$payment_client_v2() : null, CommaSeparatedCodes.INSTANCE.format($query.getPaymentMethodCodes()), CommaSeparatedCodes.INSTANCE.format($query.getCurrencyCodes()), CommaSeparatedCodes.INSTANCE.format($query.getSegmentCodes()), CommaSeparatedCodes.INSTANCE.format($query.getPaymentOperatorCodes()));
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListCurrenciesEndpoint() {
        return Factory.defineListCurrenciesEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListPaymentMethodsEndpoint() {
        return Factory.defineListPaymentMethodsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListPaymentOperatorsEndpoint() {
        return Factory.defineListPaymentOperatorsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListPaymentOptionsEndpoint() {
        return Factory.defineListPaymentOptionsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListSegmentsEndpoint() {
        return Factory.defineListSegmentsEndpoint();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
        return Factory.create(context, accessToken, callTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
        return Factory.create(context, accessToken);
    }

    public /* synthetic */ PaymentsApi(int apiVersion, EnhancedPaymentsApi api, DefaultConstructorMarker $constructor_marker) {
        this(apiVersion, api);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007J\b\u0010\t\u001a\u00020\u0005H\u0007J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$Factory;", "", "<init>", "()V", "defineListCurrenciesEndpoint", "Ltech/carpentum/sdk/payment/EndpointDefinition;", "defineListPaymentMethodsEndpoint", "defineListPaymentOperatorsEndpoint", "defineListPaymentOptionsEndpoint", "defineListSegmentsEndpoint", "create", "Ltech/carpentum/sdk/payment/PaymentsApi;", "context", "Ltech/carpentum/sdk/payment/PaymentContext;", "accessToken", "", "callTimeout", "Ljava/time/Duration;", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListCurrenciesEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/currencies");
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListPaymentMethodsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/payment-methods");
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListPaymentOperatorsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/payment-operators");
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListPaymentOptionsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/payment-options");
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListSegmentsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/segments");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            int n = context.getApiVersion();
            String string = context.getApiBaseUrl();
            String string2 = context.getBrand();
            Duration duration = callTimeout;
            if (duration == null) {
                duration = context.getDefaultCallTimeout();
            }
            return new PaymentsApi(n, new EnhancedPaymentsApi(string, accessToken, string2, duration), null);
        }

        public static /* synthetic */ PaymentsApi create$default(Factory factory, PaymentContext paymentContext, String string, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                duration = null;
            }
            return factory.create(paymentContext, string, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return tech.carpentum.sdk.payment.PaymentsApi$Factory.create$default(this, context, accessToken, null, 4, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00172\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B]\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0012\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001a"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery;", "", "paymentTypeCode", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$PaymentTypeCode;", "paymentMethodCodes", "", "", "currencyCodes", "segmentCodes", "paymentOperatorCodes", "<init>", "(Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$PaymentTypeCode;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "builder", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl;", "(Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl;)V", "getPaymentTypeCode", "()Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$PaymentTypeCode;", "getPaymentMethodCodes", "()Ljava/util/Set;", "getCurrencyCodes", "getSegmentCodes", "getPaymentOperatorCodes", "PaymentTypeCode", "Factory", "Builder", "BuilderImpl", "payment-client-v2"})
    public static final class ListPaymentOptionsQuery {
        @NotNull
        public static final Factory Factory = new Factory(null);
        @Nullable
        private final PaymentTypeCode paymentTypeCode;
        @Nullable
        private final Set<String> paymentMethodCodes;
        @Nullable
        private final Set<String> currencyCodes;
        @Nullable
        private final Set<String> segmentCodes;
        @Nullable
        private final Set<String> paymentOperatorCodes;
        @NotNull
        private static final ListPaymentOptionsQuery empty;

        private ListPaymentOptionsQuery(PaymentTypeCode paymentTypeCode, Set<String> paymentMethodCodes, Set<String> currencyCodes, Set<String> segmentCodes, Set<String> paymentOperatorCodes) {
            this.paymentTypeCode = paymentTypeCode;
            this.paymentMethodCodes = paymentMethodCodes;
            this.currencyCodes = currencyCodes;
            this.segmentCodes = segmentCodes;
            this.paymentOperatorCodes = paymentOperatorCodes;
        }

        /* synthetic */ ListPaymentOptionsQuery(PaymentTypeCode paymentTypeCode, Set set, Set set2, Set set3, Set set4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                paymentTypeCode = null;
            }
            if ((n & 2) != 0) {
                set = null;
            }
            if ((n & 4) != 0) {
                set2 = null;
            }
            if ((n & 8) != 0) {
                set3 = null;
            }
            if ((n & 0x10) != 0) {
                set4 = null;
            }
            this(paymentTypeCode, set, set2, set3, set4);
        }

        @Nullable
        public final PaymentTypeCode getPaymentTypeCode() {
            return this.paymentTypeCode;
        }

        @Nullable
        public final Set<String> getPaymentMethodCodes() {
            return this.paymentMethodCodes;
        }

        @Nullable
        public final Set<String> getCurrencyCodes() {
            return this.currencyCodes;
        }

        @Nullable
        public final Set<String> getSegmentCodes() {
            return this.segmentCodes;
        }

        @Nullable
        public final Set<String> getPaymentOperatorCodes() {
            return this.paymentOperatorCodes;
        }

        private ListPaymentOptionsQuery(BuilderImpl builder) {
            this(builder.getPaymentTypeCode(), builder.getPaymentMethodCodes(), builder.getCurrencyCodes(), builder.getSegmentCodes(), builder.getPaymentOperatorCodes());
        }

        @JvmStatic
        @NotNull
        public static final Builder builder() {
            return Factory.builder();
        }

        @JvmStatic
        @NotNull
        public static Builder paymentTypeCode(@NotNull PaymentTypeCode paymentTypeCode) {
            return Factory.paymentTypeCode(paymentTypeCode);
        }

        @JvmStatic
        @NotNull
        public static Builder paymentMethodCodes(String ... codes) {
            return Factory.paymentMethodCodes(codes);
        }

        @JvmStatic
        @NotNull
        public static Builder paymentMethodCodes(Enum<?> ... codes) {
            return Factory.paymentMethodCodes(codes);
        }

        @JvmStatic
        @NotNull
        public static Builder currencyCodes(String ... codes) {
            return Factory.currencyCodes(codes);
        }

        @JvmStatic
        @NotNull
        public static Builder segmentCodes(String ... codes) {
            return Factory.segmentCodes(codes);
        }

        @JvmStatic
        @NotNull
        public static Builder paymentOperatorCodes(String ... codes) {
            return Factory.paymentOperatorCodes(codes);
        }

        @JvmStatic
        @NotNull
        public static final ListPaymentOptionsQuery any() {
            return Factory.any();
        }

        public /* synthetic */ ListPaymentOptionsQuery(BuilderImpl builder, DefaultConstructorMarker $constructor_marker) {
            this(builder);
        }

        static {
            Object t = Factory.builder().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            empty = (ListPaymentOptionsQuery)t;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0005\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001J\u0010\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H&J!\u0010\u0005\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH&\u00a2\u0006\u0002\u0010\tJ)\u0010\u0005\u001a\u00020\u00002\u001a\u0010\u0006\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\u0007\"\u0006\u0012\u0002\b\u00030\nH&\u00a2\u0006\u0002\u0010\u000bJ!\u0010\f\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH&\u00a2\u0006\u0002\u0010\tJ!\u0010\r\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH&\u00a2\u0006\u0002\u0010\tJ!\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH&\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000f"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "Ljava/util/function/Supplier;", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery;", "paymentTypeCode", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$PaymentTypeCode;", "paymentMethodCodes", "codes", "", "", "([Ljava/lang/String;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "", "([Ljava/lang/Enum;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "currencyCodes", "segmentCodes", "paymentOperatorCodes", "payment-client-v2"})
        public static interface Builder
        extends Supplier<ListPaymentOptionsQuery> {
            @NotNull
            public Builder paymentTypeCode(@NotNull PaymentTypeCode var1);

            @NotNull
            public Builder paymentMethodCodes(String ... var1);

            @NotNull
            public Builder paymentMethodCodes(Enum<?> ... var1);

            @NotNull
            public Builder currencyCodes(String ... var1);

            @NotNull
            public Builder segmentCodes(String ... var1);

            @NotNull
            public Builder paymentOperatorCodes(String ... var1);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J!\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0015\"\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0016J)\u0010\u000b\u001a\u00020\u00002\u001a\u0010\u0014\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u0015\"\u0006\u0012\u0002\b\u00030\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J!\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0015\"\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0010\u001a\u00020\u00002\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0015\"\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0015\"\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR.\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR.\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR.\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR.\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u001b"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl;", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "<init>", "()V", "value", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$PaymentTypeCode;", "paymentTypeCode", "getPaymentTypeCode", "()Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$PaymentTypeCode;", "", "", "paymentMethodCodes", "getPaymentMethodCodes", "()Ljava/util/Set;", "currencyCodes", "getCurrencyCodes", "segmentCodes", "getSegmentCodes", "paymentOperatorCodes", "getPaymentOperatorCodes", "codes", "", "([Ljava/lang/String;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl;", "", "([Ljava/lang/Enum;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl;", "get", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery;", "payment-client-v2"})
        @SourceDebugExtension(value={"SMAP\nPaymentsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentsApi.kt\ntech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,352:1\n11102#2:353\n11437#2,3:354\n37#3,2:357\n*S KotlinDebug\n*F\n+ 1 PaymentsApi.kt\ntech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl\n*L\n250#1:353\n250#1:354,3\n250#1:357,2\n*E\n"})
        private static final class BuilderImpl
        implements Builder {
            @Nullable
            private PaymentTypeCode paymentTypeCode;
            @Nullable
            private Set<String> paymentMethodCodes;
            @Nullable
            private Set<String> currencyCodes;
            @Nullable
            private Set<String> segmentCodes;
            @Nullable
            private Set<String> paymentOperatorCodes;

            @Nullable
            public final PaymentTypeCode getPaymentTypeCode() {
                return this.paymentTypeCode;
            }

            @Nullable
            public final Set<String> getPaymentMethodCodes() {
                return this.paymentMethodCodes;
            }

            @Nullable
            public final Set<String> getCurrencyCodes() {
                return this.currencyCodes;
            }

            @Nullable
            public final Set<String> getSegmentCodes() {
                return this.segmentCodes;
            }

            @Nullable
            public final Set<String> getPaymentOperatorCodes() {
                return this.paymentOperatorCodes;
            }

            @Override
            @NotNull
            public BuilderImpl paymentTypeCode(@NotNull PaymentTypeCode paymentTypeCode) {
                BuilderImpl builderImpl;
                Intrinsics.checkNotNullParameter((Object)((Object)paymentTypeCode), (String)"paymentTypeCode");
                BuilderImpl $this$paymentTypeCode_u24lambda_u240 = builderImpl = this;
                boolean bl = false;
                $this$paymentTypeCode_u24lambda_u240.paymentTypeCode = paymentTypeCode;
                return builderImpl;
            }

            @Override
            @NotNull
            public BuilderImpl paymentMethodCodes(String ... codes) {
                BuilderImpl builderImpl;
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                BuilderImpl $this$paymentMethodCodes_u24lambda_u241 = builderImpl = this;
                boolean bl = false;
                $this$paymentMethodCodes_u24lambda_u241.paymentMethodCodes = CommaSeparatedCodes.INSTANCE.of(Arrays.copyOf(codes, codes.length));
                return builderImpl;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public BuilderImpl paymentMethodCodes(Enum<?> ... codes) {
                void $this$toTypedArray$iv;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                BuilderImpl builderImpl;
                Intrinsics.checkNotNullParameter(codes, (String)"codes");
                BuilderImpl $this$paymentMethodCodes_u24lambda_u243 = builderImpl = this;
                boolean bl = false;
                Enum<?>[] enumArray = codes;
                CommaSeparatedCodes commaSeparatedCodes = CommaSeparatedCodes.INSTANCE;
                BuilderImpl builderImpl2 = $this$paymentMethodCodes_u24lambda_u243;
                boolean $i$f$map = false;
                void var9_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var15_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.name());
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                builderImpl2.paymentMethodCodes = commaSeparatedCodes.of(Arrays.copyOf(stringArray, stringArray.length));
                return builderImpl;
            }

            @Override
            @NotNull
            public BuilderImpl currencyCodes(String ... codes) {
                BuilderImpl builderImpl;
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                BuilderImpl $this$currencyCodes_u24lambda_u244 = builderImpl = this;
                boolean bl = false;
                $this$currencyCodes_u24lambda_u244.currencyCodes = CommaSeparatedCodes.INSTANCE.of(Arrays.copyOf(codes, codes.length));
                return builderImpl;
            }

            @Override
            @NotNull
            public BuilderImpl segmentCodes(String ... codes) {
                BuilderImpl builderImpl;
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                BuilderImpl $this$segmentCodes_u24lambda_u245 = builderImpl = this;
                boolean bl = false;
                $this$segmentCodes_u24lambda_u245.segmentCodes = CommaSeparatedCodes.INSTANCE.of(Arrays.copyOf(codes, codes.length));
                return builderImpl;
            }

            @Override
            @NotNull
            public BuilderImpl paymentOperatorCodes(String ... codes) {
                BuilderImpl builderImpl;
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                BuilderImpl $this$paymentOperatorCodes_u24lambda_u246 = builderImpl = this;
                boolean bl = false;
                $this$paymentOperatorCodes_u24lambda_u246.paymentOperatorCodes = CommaSeparatedCodes.INSTANCE.of(Arrays.copyOf(codes, codes.length));
                return builderImpl;
            }

            @Override
            @NotNull
            public ListPaymentOptionsQuery get() {
                return new ListPaymentOptionsQuery(this, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0001H\u0007J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0017J!\u0010\t\u001a\u00020\u00012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0017\u00a2\u0006\u0002\u0010\rJ)\u0010\t\u001a\u00020\u00012\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000e0\u000b\"\u0006\u0012\u0002\b\u00030\u000eH\u0017\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0010\u001a\u00020\u00012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0017\u00a2\u0006\u0002\u0010\rJ!\u0010\u0011\u001a\u00020\u00012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0017\u00a2\u0006\u0002\u0010\rJ!\u0010\u0012\u001a\u00020\u00012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0017\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Factory;", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "<init>", "()V", "empty", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery;", "builder", "paymentTypeCode", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$PaymentTypeCode;", "paymentMethodCodes", "codes", "", "", "([Ljava/lang/String;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "", "([Ljava/lang/Enum;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "currencyCodes", "segmentCodes", "paymentOperatorCodes", "get", "any", "payment-client-v2"})
        @SourceDebugExtension(value={"SMAP\nPaymentsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentsApi.kt\ntech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Factory\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,352:1\n11102#2:353\n11437#2,3:354\n37#3,2:357\n*S KotlinDebug\n*F\n+ 1 PaymentsApi.kt\ntech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Factory\n*L\n173#1:353\n173#1:354,3\n173#1:357,2\n*E\n"})
        public static final class Factory
        implements Builder {
            private Factory() {
            }

            @JvmStatic
            @NotNull
            public final Builder builder() {
                return new BuilderImpl();
            }

            @Override
            @JvmStatic
            @NotNull
            public Builder paymentTypeCode(@NotNull PaymentTypeCode paymentTypeCode) {
                Intrinsics.checkNotNullParameter((Object)((Object)paymentTypeCode), (String)"paymentTypeCode");
                return this.builder().paymentTypeCode(paymentTypeCode);
            }

            @Override
            @JvmStatic
            @NotNull
            public Builder paymentMethodCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                return this.builder().paymentMethodCodes(Arrays.copyOf(codes, codes.length));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @JvmStatic
            @NotNull
            public Builder paymentMethodCodes(Enum<?> ... codes) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(codes, (String)"codes");
                Enum<?>[] enumArray = codes;
                Builder builder = this.builder();
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.name());
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                return builder.paymentMethodCodes(Arrays.copyOf(stringArray, stringArray.length));
            }

            @Override
            @JvmStatic
            @NotNull
            public Builder currencyCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                return this.builder().currencyCodes(Arrays.copyOf(codes, codes.length));
            }

            @Override
            @JvmStatic
            @NotNull
            public Builder segmentCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                return this.builder().segmentCodes(Arrays.copyOf(codes, codes.length));
            }

            @Override
            @JvmStatic
            @NotNull
            public Builder paymentOperatorCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                return this.builder().paymentOperatorCodes(Arrays.copyOf(codes, codes.length));
            }

            @Override
            @NotNull
            public ListPaymentOptionsQuery get() {
                Object t = this.builder().get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                return (ListPaymentOptionsQuery)t;
            }

            @JvmStatic
            @NotNull
            public final ListPaymentOptionsQuery any() {
                return empty;
            }

            public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\n"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$PaymentTypeCode;", "", "<init>", "(Ljava/lang/String;I)V", "PAYIN", "PAYOUT", "TOPUP_WALLET", "toModel", "Ltech/carpentum/sdk/payment/internal/generated/api/PaymentsApi$PaymentTypeCodeGetPaymentOptions;", "toModel$payment_client_v2", "payment-client-v2"})
        public static final class PaymentTypeCode
        extends Enum<PaymentTypeCode> {
            public static final /* enum */ PaymentTypeCode PAYIN = new PaymentTypeCode();
            public static final /* enum */ PaymentTypeCode PAYOUT = new PaymentTypeCode();
            public static final /* enum */ PaymentTypeCode TOPUP_WALLET = new PaymentTypeCode();
            private static final /* synthetic */ PaymentTypeCode[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            @NotNull
            public final PaymentsApi.PaymentTypeCodeGetPaymentOptions toModel$payment_client_v2() {
                return PaymentsApi.PaymentTypeCodeGetPaymentOptions.valueOf(this.name());
            }

            public static PaymentTypeCode[] values() {
                return (PaymentTypeCode[])$VALUES.clone();
            }

            public static PaymentTypeCode valueOf(String value) {
                return Enum.valueOf(PaymentTypeCode.class, value);
            }

            @NotNull
            public static EnumEntries<PaymentTypeCode> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = paymentTypeCodeArray = new PaymentTypeCode[]{PaymentTypeCode.PAYIN, PaymentTypeCode.PAYOUT, PaymentTypeCode.TOPUP_WALLET};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

