/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.CodePaymentMethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseCodePayment;
import tech.carpentum.sdk.payment.model.AccountResponseCodePayment;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public interface CodePaymentMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.CODE_PAYMENT;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public AccountResponseCodePayment getAccount();

    @NotNull
    public AccountCustomerResponseCodePayment getAccountCustomer();

    @NotNull
    public MoneyPaymentResponse getMoney();

    @NotNull
    public Optional<MoneyVat> getVat();

    @NotNull
    public String getReference();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public PaymentOperatorIncoming getPaymentOperator();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(CodePaymentMethodResponse copyOf) {
        Builder builder = CodePaymentMethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.account(copyOf.getAccount());
        builder.accountCustomer(copyOf.getAccountCustomer());
        builder.money(copyOf.getMoney());
        builder.vat(copyOf.getVat().orElse(null));
        builder.reference(copyOf.getReference());
        builder.returnUrl(copyOf.getReturnUrl());
        builder.paymentOperator(copyOf.getPaymentOperator());
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new CodePaymentMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        @NotNull
        public Builder idPayment(IdPayment var1);

        @NotNull
        public Builder account(AccountResponseCodePayment var1);

        @NotNull
        public Builder accountCustomer(AccountCustomerResponseCodePayment var1);

        @NotNull
        public Builder money(MoneyPaymentResponse var1);

        @NotNull
        public Builder vat(MoneyVat var1);

        @NotNull
        public Builder reference(String var1);

        @NotNull
        public Builder returnUrl(String var1);

        @NotNull
        public Builder paymentOperator(PaymentOperatorIncoming var1);

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        @NotNull
        public CodePaymentMethodResponse build();
    }
}

