/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.TopUpImpl;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.TopUpRequested;

@JsonClass(generateAdapter=false)
public interface TopUp {
    @NotNull
    public TopUpRequested getTopUpRequested();

    @NotNull
    public PayinMethod getPaymentMethod();

    @NotNull
    public Optional<String> getCallbackUrl();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public Optional<String> getCustomerIp();

    @NotNull
    public static Builder builder(TopUp copyOf) {
        Builder builder = TopUp.builder();
        builder.topUpRequested(copyOf.getTopUpRequested());
        builder.paymentMethod(copyOf.getPaymentMethod());
        builder.callbackUrl(copyOf.getCallbackUrl().orElse(null));
        builder.returnUrl(copyOf.getReturnUrl());
        builder.customerIp(copyOf.getCustomerIp().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new TopUpImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder topUpRequested(TopUpRequested var1);

        @NotNull
        public Builder paymentMethod(PayinMethod var1);

        @NotNull
        public Builder callbackUrl(String var1);

        @NotNull
        public Builder returnUrl(String var1);

        @NotNull
        public Builder customerIp(String var1);

        @NotNull
        public TopUp build();
    }
}

