/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AccountResponseDetailImpl;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public interface AccountResponseDetail {
    @NotNull
    public Optional<String> getAccountName();

    @NotNull
    public Optional<String> getAccountNumber();

    @NotNull
    public Optional<String> getAccountType();

    @NotNull
    public Optional<String> getBankCode();

    @NotNull
    public Optional<PaymentOperatorIncoming> getPaymentOperator();

    @NotNull
    public Optional<String> getBankName();

    @NotNull
    public Optional<String> getBankBranch();

    @NotNull
    public Optional<String> getBankCity();

    @NotNull
    public Optional<String> getBankProvince();

    @NotNull
    public static Builder builder(AccountResponseDetail copyOf) {
        Builder builder = AccountResponseDetail.builder();
        builder.accountName(copyOf.getAccountName().orElse(null));
        builder.accountNumber(copyOf.getAccountNumber().orElse(null));
        builder.accountType(copyOf.getAccountType().orElse(null));
        builder.bankCode(copyOf.getBankCode().orElse(null));
        builder.paymentOperator(copyOf.getPaymentOperator().orElse(null));
        builder.bankName(copyOf.getBankName().orElse(null));
        builder.bankBranch(copyOf.getBankBranch().orElse(null));
        builder.bankCity(copyOf.getBankCity().orElse(null));
        builder.bankProvince(copyOf.getBankProvince().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new AccountResponseDetailImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder accountName(String var1);

        @NotNull
        public Builder accountNumber(String var1);

        @NotNull
        public Builder accountType(String var1);

        @NotNull
        public Builder bankCode(String var1);

        @NotNull
        public Builder paymentOperator(PaymentOperatorIncoming var1);

        @NotNull
        public Builder bankName(String var1);

        @NotNull
        public Builder bankBranch(String var1);

        @NotNull
        public Builder bankCity(String var1);

        @NotNull
        public Builder bankProvince(String var1);

        @NotNull
        public AccountResponseDetail build();
    }
}

