/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import java.util.Objects;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.MoneyFee;

@JsonClass(generateAdapter=false)
public class MoneyFeeImpl
implements MoneyFee {
    private final BigDecimal amount;
    private final CurrencyCode currencyCode;
    private final int hashCode;
    private final String toString;

    @Override
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    private MoneyFeeImpl(BuilderImpl builder) {
        this.amount = Objects.requireNonNull(builder.amount, "Property 'amount' is required.");
        this.currencyCode = Objects.requireNonNull(builder.currencyCode, "Property 'currencyCode' is required.");
        this.hashCode = Objects.hash(this.amount, this.currencyCode);
        this.toString = builder.type + "(amount=" + this.amount + ", currencyCode=" + this.currencyCode + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoneyFeeImpl)) {
            return false;
        }
        MoneyFeeImpl that = (MoneyFeeImpl)obj;
        if (!Objects.equals(this.amount, that.amount)) {
            return false;
        }
        return Objects.equals(this.currencyCode, that.currencyCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements MoneyFee.Builder {
        private BigDecimal amount = null;
        private CurrencyCode currencyCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("MoneyFee");
        }

        @Override
        public BuilderImpl amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public BuilderImpl currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public MoneyFeeImpl build() {
            return new MoneyFeeImpl(this);
        }
    }
}

