/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AvailableTopUpOptionImpl;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodCode;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public interface AvailableTopUpOption {
    @NotNull
    public Money getMoneyPay();

    @NotNull
    public Money getMoneyReceive();

    @NotNull
    public PayinMethodCode getPaymentMethodCode();

    @NotNull
    public @NotNull List<@NotNull PaymentOperatorIncoming> getPaymentOperators();

    @NotNull
    public static Builder builder(AvailableTopUpOption copyOf) {
        Builder builder = AvailableTopUpOption.builder();
        builder.moneyPay(copyOf.getMoneyPay());
        builder.moneyReceive(copyOf.getMoneyReceive());
        builder.paymentMethodCode(copyOf.getPaymentMethodCode());
        builder.paymentOperators(copyOf.getPaymentOperators());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new AvailableTopUpOptionImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder moneyPay(Money var1);

        @NotNull
        public Builder moneyReceive(Money var1);

        @NotNull
        public Builder paymentMethodCode(PayinMethodCode var1);

        @NotNull
        public Builder paymentOperators(List<@NotNull PaymentOperatorIncoming> var1);

        @NotNull
        public Builder paymentOperatorsAdd(PaymentOperatorIncoming var1);

        @NotNull
        public Builder paymentOperatorsAddAll(List<@NotNull PaymentOperatorIncoming> var1);

        @NotNull
        public AvailableTopUpOption build();
    }
}

