/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.io.InterruptedIOException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.EndpointDefinition;
import tech.carpentum.sdk.payment.PaymentContext;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.ClientErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.EnhancedMerchantInfoApi;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.MerchantInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ltech/carpentum/sdk/payment/MerchantInfoApi;", "", "apiVersion", "", "api", "Ltech/carpentum/sdk/payment/internal/api/EnhancedMerchantInfoApi;", "<init>", "(ILtech/carpentum/sdk/payment/internal/api/EnhancedMerchantInfoApi;)V", "getMerchantInfo", "Ltech/carpentum/sdk/payment/model/MerchantInfo;", "Factory", "payment-client-v2"})
public final class MerchantInfoApi {
    @NotNull
    public static final Factory Factory = new Factory(null);
    private final int apiVersion;
    @NotNull
    private final EnhancedMerchantInfoApi api;

    private MerchantInfoApi(int apiVersion, EnhancedMerchantInfoApi api) {
        this.apiVersion = apiVersion;
        this.api = api;
    }

    @NotNull
    public final MerchantInfo getMerchantInfo() throws ResponseException, InterruptedIOException {
        return (MerchantInfo)ResponseExceptionUtils.INSTANCE.wrap(ClientErrorExceptionFactory.Companion.getInstance(), () -> MerchantInfoApi.getMerchantInfo$lambda$0(this));
    }

    private static final MerchantInfo getMerchantInfo$lambda$0(MerchantInfoApi this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.api.getMerchantInfo(this$0.apiVersion);
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineGetMerchantInfoEndpoint() {
        return Factory.defineGetMerchantInfoEndpoint();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MerchantInfoApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
        return Factory.create(context, accessToken, callTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MerchantInfoApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
        return Factory.create(context, accessToken);
    }

    public /* synthetic */ MerchantInfoApi(int apiVersion, EnhancedMerchantInfoApi api, DefaultConstructorMarker $constructor_marker) {
        this(apiVersion, api);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a8\u0006\u000e"}, d2={"Ltech/carpentum/sdk/payment/MerchantInfoApi$Factory;", "", "<init>", "()V", "defineGetMerchantInfoEndpoint", "Ltech/carpentum/sdk/payment/EndpointDefinition;", "create", "Ltech/carpentum/sdk/payment/MerchantInfoApi;", "context", "Ltech/carpentum/sdk/payment/PaymentContext;", "accessToken", "", "callTimeout", "Ljava/time/Duration;", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineGetMerchantInfoEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/merchant-info");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final MerchantInfoApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            int n = context.getApiVersion();
            String string = context.getApiBaseUrl();
            Duration duration = callTimeout;
            if (duration == null) {
                duration = context.getDefaultCallTimeout();
            }
            return new MerchantInfoApi(n, new EnhancedMerchantInfoApi(string, accessToken, duration), null);
        }

        public static /* synthetic */ MerchantInfoApi create$default(Factory factory, PaymentContext paymentContext, String string, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                duration = null;
            }
            return factory.create(paymentContext, string, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final MerchantInfoApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return tech.carpentum.sdk.payment.MerchantInfoApi$Factory.create$default(this, context, accessToken, null, 4, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

