/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.DuitNowMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestDuitNow;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface DuitNowMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.DUITNOW;

    @NotNull
    public AccountPayinRequestDuitNow getAccount();

    @NotNull
    public Optional<String> getPaymentOperatorCode();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public static Builder builder(DuitNowMethod copyOf) {
        Builder builder = DuitNowMethod.builder();
        builder.account(copyOf.getAccount());
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode().orElse(null));
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new DuitNowMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestDuitNow var1);

        @NotNull
        public Builder paymentOperatorCode(String var1);

        @NotNull
        public Builder emailAddress(String var1);

        @NotNull
        public DuitNowMethod build();
    }
}

