/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.api;

import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.api.IncomingPaymentsApi;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiClient;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiResponse;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Informational;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Redirection;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestConfig;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestMethod;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseExtensionsKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseType;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Serializer;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Success;
import tech.carpentum.sdk.payment.model.AvailablePayinOptionList;
import tech.carpentum.sdk.payment.model.ExternalReference;
import tech.carpentum.sdk.payment.model.Payin;
import tech.carpentum.sdk.payment.model.PayinAcceptedResponse;
import tech.carpentum.sdk.payment.model.PayinDetail;
import tech.carpentum.sdk.payment.model.PaymentAccountDetail;
import tech.carpentum.sdk.payment.model.PaymentRequested;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ&\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u001e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u001e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001e\u0010!\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#J$\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#J&\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#\u00a8\u0006'"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/api/IncomingPaymentsApi;", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient;", "basePath", "", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "createPayin", "Ltech/carpentum/sdk/payment/model/PayinAcceptedResponse;", "xAPIVersion", "", "idPayin", "payin", "Ltech/carpentum/sdk/payment/model/Payin;", "createPayinRequestConfig", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/RequestConfig;", "createPayinWithHttpInfo", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiResponse;", "getPayin", "Ltech/carpentum/sdk/payment/model/PayinDetail;", "getPayinRequestConfig", "", "getPayinWithHttpInfo", "payinAccounts", "Ltech/carpentum/sdk/payment/model/PaymentAccountDetail;", "payinAccountsRequestConfig", "payinAccountsWithHttpInfo", "payinAvailablePaymentOptions", "Ltech/carpentum/sdk/payment/model/AvailablePayinOptionList;", "paymentRequested", "Ltech/carpentum/sdk/payment/model/PaymentRequested;", "payinAvailablePaymentOptionsRequestConfig", "payinAvailablePaymentOptionsWithHttpInfo", "payinSetExternalReference", "externalReference", "Ltech/carpentum/sdk/payment/model/ExternalReference;", "payinSetExternalReferenceRequestConfig", "payinSetExternalReferenceWithHttpInfo", "Companion", "payment-client-v2"})
@SourceDebugExtension(value={"SMAP\nIncomingPaymentsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncomingPaymentsApi.kt\ntech/carpentum/sdk/payment/internal/generated/api/IncomingPaymentsApi\n+ 2 ApiClient.kt\ntech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,438:1\n148#2,9:439\n157#2:449\n158#2,2:451\n160#2:454\n161#2,24:456\n62#2,51:480\n185#2,3:531\n62#2,51:534\n188#2:585\n62#2,51:586\n189#2:637\n62#2,51:638\n190#2,22:689\n116#2,19:711\n135#2:731\n212#2,14:732\n148#2,9:747\n157#2:757\n158#2,2:759\n160#2:762\n161#2,24:764\n62#2,51:788\n185#2,3:839\n62#2,51:842\n188#2:893\n62#2,51:894\n189#2:945\n62#2,51:946\n190#2,22:997\n116#2,19:1019\n135#2:1039\n212#2,14:1040\n148#2,9:1054\n157#2:1064\n158#2,2:1066\n160#2:1069\n161#2,24:1071\n62#2,51:1095\n185#2,3:1146\n62#2,51:1149\n188#2:1200\n62#2,51:1201\n189#2:1252\n62#2,51:1253\n190#2,22:1304\n116#2,19:1326\n135#2:1346\n212#2,14:1347\n148#2,9:1361\n157#2:1371\n158#2,2:1373\n160#2:1376\n161#2,24:1378\n62#2,51:1402\n185#2,3:1453\n62#2,51:1456\n188#2:1507\n62#2,51:1508\n189#2:1559\n62#2,51:1560\n190#2,22:1611\n116#2,19:1633\n135#2:1653\n212#2,14:1654\n148#2,9:1668\n157#2:1678\n158#2,2:1680\n160#2:1683\n161#2,24:1685\n62#2,51:1709\n185#2,3:1760\n62#2,51:1763\n188#2:1814\n62#2,51:1815\n189#2:1866\n62#2,51:1867\n190#2,22:1918\n116#2,19:1940\n135#2:1960\n212#2,14:1961\n215#3:448\n216#3:455\n215#3:756\n216#3:763\n215#3:1063\n216#3:1070\n215#3:1370\n216#3:1377\n215#3:1677\n216#3:1684\n1855#4:450\n1856#4:453\n1855#4:758\n1856#4:761\n1855#4:1065\n1856#4:1068\n1855#4:1372\n1856#4:1375\n1855#4:1679\n1856#4:1682\n29#5:730\n29#5:1038\n29#5:1345\n29#5:1652\n29#5:1959\n1#6:746\n*S KotlinDebug\n*F\n+ 1 IncomingPaymentsApi.kt\ntech/carpentum/sdk/payment/internal/generated/api/IncomingPaymentsApi\n*L\n108#1:439,9\n108#1:449\n108#1:451,2\n108#1:454\n108#1:456,24\n108#1:480,51\n108#1:531,3\n108#1:534,51\n108#1:585\n108#1:586,51\n108#1:637\n108#1:638,51\n108#1:689,22\n108#1:711,19\n108#1:731\n108#1:732,14\n184#1:747,9\n184#1:757\n184#1:759,2\n184#1:762\n184#1:764,24\n184#1:788,51\n184#1:839,3\n184#1:842,51\n184#1:893\n184#1:894,51\n184#1:945\n184#1:946,51\n184#1:997,22\n184#1:1019,19\n184#1:1039\n184#1:1040,14\n258#1:1054,9\n258#1:1064\n258#1:1066,2\n258#1:1069\n258#1:1071,24\n258#1:1095,51\n258#1:1146,3\n258#1:1149,51\n258#1:1200\n258#1:1201,51\n258#1:1252\n258#1:1253,51\n258#1:1304,22\n258#1:1326,19\n258#1:1346\n258#1:1347,14\n332#1:1361,9\n332#1:1371\n332#1:1373,2\n332#1:1376\n332#1:1378,24\n332#1:1402,51\n332#1:1453,3\n332#1:1456,51\n332#1:1507\n332#1:1508,51\n332#1:1559\n332#1:1560,51\n332#1:1611,22\n332#1:1633,19\n332#1:1653\n332#1:1654,14\n407#1:1668,9\n407#1:1678\n407#1:1680,2\n407#1:1683\n407#1:1685,24\n407#1:1709,51\n407#1:1760,3\n407#1:1763,51\n407#1:1814\n407#1:1815,51\n407#1:1866\n407#1:1867,51\n407#1:1918,22\n407#1:1940,19\n407#1:1960\n407#1:1961,14\n108#1:448\n108#1:455\n184#1:756\n184#1:763\n258#1:1063\n258#1:1070\n332#1:1370\n332#1:1377\n407#1:1677\n407#1:1684\n108#1:450\n108#1:453\n184#1:758\n184#1:761\n258#1:1065\n258#1:1068\n332#1:1372\n332#1:1375\n407#1:1679\n407#1:1682\n108#1:730\n184#1:1038\n258#1:1345\n332#1:1652\n407#1:1959\n*E\n"})
public class IncomingPaymentsApi
extends ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<String> defaultBasePath$delegate = LazyKt.lazy((Function0)Companion.defaultBasePath.2.INSTANCE);

    public IncomingPaymentsApi(@NotNull String basePath, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(basePath, client);
    }

    public /* synthetic */ IncomingPaymentsApi(String string, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = Companion.getDefaultBasePath();
        }
        this(string, okHttpClient);
    }

    @NotNull
    public final PayinAcceptedResponse createPayin(int xAPIVersion, @NotNull String idPayin, @NotNull Payin payin) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)payin, (String)"payin");
        ApiResponse<PayinAcceptedResponse> localVarResponse = this.createPayinWithHttpInfo(xAPIVersion, idPayin, payin);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.model.PayinAcceptedResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (PayinAcceptedResponse)t;
    }

    @NotNull
    public final ApiResponse<PayinAcceptedResponse> createPayinWithHttpInfo(int xAPIVersion, @NotNull String idPayin, @NotNull Payin payin) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)payin, (String)"payin");
        RequestConfig<Payin> localVariableConfig = this.createPayinRequestConfig(xAPIVersion, idPayin, payin);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv232 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object apiClient = $this$forEach$iv$iv.entrySet().iterator();
        while (apiClient.hasNext()) {
            Map.Entry<String, List<String>> entry;
            Map.Entry<String, List<String>> query$iv = entry = apiClient.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv232 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv232.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                apiClient = this_$iv;
                Payin payin2 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (payin2 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)payin2), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)payin2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)payin2);
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        boolean bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)payin2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)payin2);
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        boolean bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (payin2 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getMoshi().adapter(Payin.class).toJson((Object)payin2);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                RequestBody requestBody;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Payin payin3 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (payin3 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)payin3), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)payin3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)payin3);
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)payin3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)payin3);
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (payin3 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getMoshi().adapter(Payin.class).toJson((Object)payin3);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Payin payin4 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (payin4 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)payin4), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)payin4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)payin4);
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)payin4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)payin4);
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (payin4 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getMoshi().adapter(Payin.class).toJson((Object)payin4);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Payin payin5 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (payin5 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)payin5), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)payin5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)payin5);
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)payin5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)payin5);
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (payin5 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getMoshi().adapter(Payin.class).toJson((Object)payin5);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl82 = false;
        Map<String, String> map = headers$iv;
        boolean $i$f$forEach1122 = false;
        Iterator<Map.Entry<String, String>> bl6 = map.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv;
            Map.Entry<String, String> header$iv = element$iv$iv = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach1122 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach1122.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object2;
            ApiClient bl82 = this_$iv;
            ResponseBody responseBody = response$iv.body();
            boolean $i$f$responseBody = false;
            if (responseBody == null) {
                object2 = null;
            } else {
                String bodyContent$iv$iv = responseBody.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object2 = null;
                } else if (Intrinsics.areEqual(PayinAcceptedResponse.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object2 = (PayinAcceptedResponse)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi $this$adapter$iv$iv$iv = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object2 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv$iv, (KType)Reflection.nullableTypeOf(PayinAcceptedResponse.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object2, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Payin> createPayinRequestConfig(int xAPIVersion, @NotNull String idPayin, @NotNull Payin payin) {
        int n;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)payin, (String)"payin");
        Payin localVariableBody = payin;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$createPayinRequestConfig_u24lambda_u240 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$createPayinRequestConfig_u24lambda_u240));
        localVariableHeaders.put("Content-Type", "application/json");
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/payins/{idPayin}", (String)"{idPayin}", (String)String.valueOf(idPayin), (boolean)false, (int)4, null);
        return new RequestConfig<Payin>(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final PayinDetail getPayin(int xAPIVersion, @NotNull String idPayin) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        ApiResponse<PayinDetail> localVarResponse = this.getPayinWithHttpInfo(xAPIVersion, idPayin);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.model.PayinDetail");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (PayinDetail)t;
    }

    @NotNull
    public final ApiResponse<PayinDetail> getPayinWithHttpInfo(int xAPIVersion, @NotNull String idPayin) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        RequestConfig<Unit> localVariableConfig = this.getPayinRequestConfig(xAPIVersion, idPayin);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv22 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Unit query$iv = element$iv$iv = object2.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv22 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object2 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl8 = false;
        Map<String, String> $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach112 = false;
        Iterator<Map.Entry<String, String>> bl6 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv3;
            Map.Entry<String, String> header$iv = element$iv$iv3 = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach112 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach112.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object3;
            ApiClient bl8 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object3 = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object3 = null;
                } else if (Intrinsics.areEqual(PayinDetail.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object3 = (PayinDetail)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi $this$adapter$iv$iv$iv = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object3 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv$iv, (KType)Reflection.nullableTypeOf(PayinDetail.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object3, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getPayinRequestConfig(int xAPIVersion, @NotNull String idPayin) {
        int n;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getPayinRequestConfig_u24lambda_u241 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getPayinRequestConfig_u24lambda_u241));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/payins/{idPayin}", (String)"{idPayin}", (String)String.valueOf(idPayin), (boolean)false, (int)4, null);
        return new RequestConfig<Object>(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final PaymentAccountDetail payinAccounts(int xAPIVersion, @NotNull String idPayin) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        ApiResponse<PaymentAccountDetail> localVarResponse = this.payinAccountsWithHttpInfo(xAPIVersion, idPayin);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.model.PaymentAccountDetail");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (PaymentAccountDetail)t;
    }

    @NotNull
    public final ApiResponse<PaymentAccountDetail> payinAccountsWithHttpInfo(int xAPIVersion, @NotNull String idPayin) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        RequestConfig<Unit> localVariableConfig = this.payinAccountsRequestConfig(xAPIVersion, idPayin);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv22 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Unit query$iv = element$iv$iv = object2.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv22 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object2 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl8 = false;
        Map<String, String> $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach112 = false;
        Iterator<Map.Entry<String, String>> bl6 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv3;
            Map.Entry<String, String> header$iv = element$iv$iv3 = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach112 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach112.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object3;
            ApiClient bl8 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object3 = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object3 = null;
                } else if (Intrinsics.areEqual(PaymentAccountDetail.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object3 = (PaymentAccountDetail)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi $this$adapter$iv$iv$iv = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object3 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv$iv, (KType)Reflection.nullableTypeOf(PaymentAccountDetail.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object3, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> payinAccountsRequestConfig(int xAPIVersion, @NotNull String idPayin) {
        int n;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$payinAccountsRequestConfig_u24lambda_u242 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$payinAccountsRequestConfig_u24lambda_u242));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/payins/{idPayin}/accounts", (String)"{idPayin}", (String)String.valueOf(idPayin), (boolean)false, (int)4, null);
        return new RequestConfig<Object>(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final AvailablePayinOptionList payinAvailablePaymentOptions(int xAPIVersion, @NotNull PaymentRequested paymentRequested) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        Intrinsics.checkNotNullParameter((Object)paymentRequested, (String)"paymentRequested");
        ApiResponse<AvailablePayinOptionList> localVarResponse = this.payinAvailablePaymentOptionsWithHttpInfo(xAPIVersion, paymentRequested);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.model.AvailablePayinOptionList");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (AvailablePayinOptionList)t;
    }

    @NotNull
    public final ApiResponse<AvailablePayinOptionList> payinAvailablePaymentOptionsWithHttpInfo(int xAPIVersion, @NotNull PaymentRequested paymentRequested) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Intrinsics.checkNotNullParameter((Object)paymentRequested, (String)"paymentRequested");
        RequestConfig<PaymentRequested> localVariableConfig = this.payinAvailablePaymentOptionsRequestConfig(xAPIVersion, paymentRequested);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv232 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object apiClient = $this$forEach$iv$iv.entrySet().iterator();
        while (apiClient.hasNext()) {
            Map.Entry<String, List<String>> entry;
            Map.Entry<String, List<String>> query$iv = entry = apiClient.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv232 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv232.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                apiClient = this_$iv;
                PaymentRequested paymentRequested2 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (paymentRequested2 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)paymentRequested2), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)paymentRequested2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)paymentRequested2);
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        boolean bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)paymentRequested2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)paymentRequested2);
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        boolean bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (paymentRequested2 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getMoshi().adapter(PaymentRequested.class).toJson((Object)paymentRequested2);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                RequestBody requestBody;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                PaymentRequested paymentRequested3 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (paymentRequested3 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)paymentRequested3), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)paymentRequested3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)paymentRequested3);
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)paymentRequested3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)paymentRequested3);
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (paymentRequested3 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getMoshi().adapter(PaymentRequested.class).toJson((Object)paymentRequested3);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                PaymentRequested paymentRequested4 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (paymentRequested4 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)paymentRequested4), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)paymentRequested4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)paymentRequested4);
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)paymentRequested4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)paymentRequested4);
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (paymentRequested4 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getMoshi().adapter(PaymentRequested.class).toJson((Object)paymentRequested4);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                PaymentRequested paymentRequested5 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (paymentRequested5 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)paymentRequested5), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)paymentRequested5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)paymentRequested5);
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)paymentRequested5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)paymentRequested5);
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (paymentRequested5 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getMoshi().adapter(PaymentRequested.class).toJson((Object)paymentRequested5);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl82 = false;
        Map<String, String> map = headers$iv;
        boolean $i$f$forEach1122 = false;
        Iterator<Map.Entry<String, String>> bl6 = map.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv;
            Map.Entry<String, String> header$iv = element$iv$iv = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach1122 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach1122.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object2;
            ApiClient bl82 = this_$iv;
            ResponseBody responseBody = response$iv.body();
            boolean $i$f$responseBody = false;
            if (responseBody == null) {
                object2 = null;
            } else {
                String bodyContent$iv$iv = responseBody.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object2 = null;
                } else if (Intrinsics.areEqual(AvailablePayinOptionList.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object2 = (AvailablePayinOptionList)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi $this$adapter$iv$iv$iv = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object2 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv$iv, (KType)Reflection.nullableTypeOf(AvailablePayinOptionList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object2, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<PaymentRequested> payinAvailablePaymentOptionsRequestConfig(int xAPIVersion, @NotNull PaymentRequested paymentRequested) {
        int n;
        Intrinsics.checkNotNullParameter((Object)paymentRequested, (String)"paymentRequested");
        PaymentRequested localVariableBody = paymentRequested;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$payinAvailablePaymentOptionsRequestConfig_u24lambda_u243 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$payinAvailablePaymentOptionsRequestConfig_u24lambda_u243));
        localVariableHeaders.put("Content-Type", "application/json");
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.POST;
        return new RequestConfig<PaymentRequested>(requestMethod, "/payins/!availablePaymentOptions", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    public final void payinSetExternalReference(int xAPIVersion, @NotNull String idPayin, @NotNull ExternalReference externalReference) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)externalReference, (String)"externalReference");
        ApiResponse<Unit> localVarResponse = this.payinSetExternalReferenceWithHttpInfo(xAPIVersion, idPayin, externalReference);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final ApiResponse<Unit> payinSetExternalReferenceWithHttpInfo(int xAPIVersion, @NotNull String idPayin, @NotNull ExternalReference externalReference) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)externalReference, (String)"externalReference");
        RequestConfig<ExternalReference> localVariableConfig = this.payinSetExternalReferenceRequestConfig(xAPIVersion, idPayin, externalReference);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv232 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object apiClient = $this$forEach$iv$iv.entrySet().iterator();
        while (apiClient.hasNext()) {
            Map.Entry<String, List<String>> entry;
            Map.Entry<String, List<String>> query$iv = entry = apiClient.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv232 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv232.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                apiClient = this_$iv;
                ExternalReference externalReference2 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (externalReference2 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)externalReference2), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)externalReference2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)externalReference2);
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        boolean bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)externalReference2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)externalReference2);
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        boolean bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (externalReference2 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getMoshi().adapter(ExternalReference.class).toJson((Object)externalReference2);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                RequestBody requestBody;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                ExternalReference externalReference3 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (externalReference3 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)externalReference3), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)externalReference3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)externalReference3);
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)externalReference3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)externalReference3);
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (externalReference3 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getMoshi().adapter(ExternalReference.class).toJson((Object)externalReference3);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                ExternalReference externalReference4 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (externalReference4 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)externalReference4), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)externalReference4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)externalReference4);
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)externalReference4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)externalReference4);
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (externalReference4 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getMoshi().adapter(ExternalReference.class).toJson((Object)externalReference4);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                ExternalReference externalReference5 = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (externalReference5 instanceof File) {
                    requestBody = RequestBody.Companion.create((File)((Object)externalReference5), MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl4 = false;
                    Intrinsics.checkNotNull((Object)externalReference5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)externalReference5);
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl3 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull((Object)externalReference5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)((Object)externalReference5);
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (externalReference5 == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getMoshi().adapter(ExternalReference.class).toJson((Object)externalReference5);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl82 = false;
        Map<String, String> map = headers$iv;
        boolean $i$f$forEach1122 = false;
        Iterator<Map.Entry<String, String>> bl6 = map.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv;
            Map.Entry<String, String> header$iv = element$iv$iv = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach1122 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach1122.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object2;
            ApiClient bl82 = this_$iv;
            ResponseBody responseBody = response$iv.body();
            boolean $i$f$responseBody = false;
            if (responseBody == null) {
                object2 = null;
            } else {
                String bodyContent$iv$iv = responseBody.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object2 = null;
                } else if (Intrinsics.areEqual(Unit.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object2 = (Unit)f$iv$iv;
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi $this$adapter$iv$iv$iv = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object2 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv$iv, (KType)Reflection.nullableTypeOf(Unit.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object2, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<ExternalReference> payinSetExternalReferenceRequestConfig(int xAPIVersion, @NotNull String idPayin, @NotNull ExternalReference externalReference) {
        int n;
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)externalReference, (String)"externalReference");
        ExternalReference localVariableBody = externalReference;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$payinSetExternalReferenceRequestConfig_u24lambda_u244 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$payinSetExternalReferenceRequestConfig_u24lambda_u244));
        localVariableHeaders.put("Content-Type", "application/json");
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/payins/{idPayin}/!setExternalReference", (String)"{idPayin}", (String)String.valueOf(idPayin), (boolean)false, (int)4, null);
        return new RequestConfig<ExternalReference>(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public static final String getDefaultBasePath() {
        return Companion.getDefaultBasePath();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/api/IncomingPaymentsApi$Companion;", "", "()V", "defaultBasePath", "", "getDefaultBasePath$annotations", "getDefaultBasePath", "()Ljava/lang/String;", "defaultBasePath$delegate", "Lkotlin/Lazy;", "payment-client-v2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultBasePath() {
            Lazy lazy = defaultBasePath$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (String)object;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultBasePath$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Informational.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Redirection.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ClientError.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ServerError.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

