/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PayoutImpl;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public interface Payout {
    @NotNull
    public PaymentRequested getPaymentRequested();

    @NotNull
    public PayoutMethod getPaymentMethod();

    @NotNull
    public Optional<String> getCallbackUrl();

    @NotNull
    public Optional<String> getCustomerIp();

    @NotNull
    public static Builder builder(Payout copyOf) {
        Builder builder = Payout.builder();
        builder.paymentRequested(copyOf.getPaymentRequested());
        builder.paymentMethod(copyOf.getPaymentMethod());
        builder.callbackUrl(copyOf.getCallbackUrl().orElse(null));
        builder.customerIp(copyOf.getCustomerIp().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PayoutImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder paymentRequested(PaymentRequested var1);

        @NotNull
        public Builder paymentMethod(PayoutMethod var1);

        @NotNull
        public Builder callbackUrl(String var1);

        @NotNull
        public Builder customerIp(String var1);

        @NotNull
        public Payout build();
    }
}

