/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.api;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.carpentum.sdk.payment.ClientBasicErrorException;
import tech.carpentum.sdk.payment.ClientBusinessValidationErrorException;
import tech.carpentum.sdk.payment.ClientErrorException;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.ServerBasicErrorException;
import tech.carpentum.sdk.payment.ServerErrorException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Serializer;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerException;
import tech.carpentum.sdk.payment.model.BasicError;
import tech.carpentum.sdk.payment.model.BusinessValidationError;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u001f\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0017R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u0007\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0006*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b \u0006*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0006*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltech/carpentum/sdk/payment/internal/api/ResponseExceptionUtils;", "", "()V", "jsonAdapterBasicError", "Lcom/squareup/moshi/JsonAdapter;", "Ltech/carpentum/sdk/payment/model/BasicError;", "kotlin.jvm.PlatformType", "jsonAdapterBusinessValidationErrorList", "", "Ltech/carpentum/sdk/payment/model/BusinessValidationError;", "logger", "Lorg/slf4j/Logger;", "clientException", "Ltech/carpentum/sdk/payment/ClientErrorException;", "cause", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ClientException;", "serverException", "Ltech/carpentum/sdk/payment/ServerErrorException;", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ServerException;", "wrap", "T", "apiCall", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "payment-client-v2"})
public final class ResponseExceptionUtils {
    @NotNull
    public static final ResponseExceptionUtils INSTANCE = new ResponseExceptionUtils();
    private static final Logger logger = LoggerFactory.getLogger(ResponseExceptionUtils.class);
    private static final JsonAdapter<BasicError> jsonAdapterBasicError = Serializer.getMoshi().adapter(BasicError.class);
    private static final JsonAdapter<List<BusinessValidationError>> jsonAdapterBusinessValidationErrorList;

    private ResponseExceptionUtils() {
    }

    private final ClientErrorException clientException(ClientException cause) {
        int statusCode = cause.getStatusCode();
        Object object = cause.getResponse();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
        }
        String bodyContent = String.valueOf(((ClientError)object).getBody());
        try {
            ClientErrorException clientErrorException;
            if (statusCode == 406) {
                Throwable throwable = cause;
                Object object2 = jsonAdapterBusinessValidationErrorList.fromJson(bodyContent);
                Intrinsics.checkNotNull((Object)object2);
                object = object2;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonAdapterBusinessValidationErrorList.fromJson(bodyContent)!!");
                clientErrorException = new ClientBusinessValidationErrorException(throwable, statusCode, (List)object);
            } else {
                Throwable throwable = cause;
                Object object3 = jsonAdapterBasicError.fromJson(bodyContent);
                Intrinsics.checkNotNull((Object)object3);
                object = object3;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonAdapterBasicError.fromJson(bodyContent)!!");
                clientErrorException = new ClientBasicErrorException(throwable, statusCode, (BasicError)object);
            }
            object = clientErrorException;
        }
        catch (Exception ex) {
            logger.debug("Error parsing response: {}", (Object)cause.getResponse(), (Object)ex);
            object = new ClientErrorException(cause, statusCode);
        }
        return object;
    }

    private final ServerErrorException serverException(ServerException cause) {
        int statusCode = cause.getStatusCode();
        Object object = cause.getResponse();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
        }
        String bodyContent = String.valueOf(((ServerError)object).getBody());
        try {
            Throwable throwable = cause;
            Object object2 = jsonAdapterBasicError.fromJson(bodyContent);
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonAdapterBasicError.fromJson(bodyContent)!!");
            object = new ServerBasicErrorException(throwable, statusCode, (BasicError)object);
        }
        catch (Exception ex) {
            logger.debug("Error parsing response: {}", (Object)cause.getResponse(), (Object)ex);
            object = new ServerErrorException(cause, statusCode);
        }
        return object;
    }

    public final <T> T wrap(@NotNull Function0<? extends T> apiCall) throws ResponseException {
        Object object;
        Intrinsics.checkNotNullParameter(apiCall, (String)"apiCall");
        try {
            object = apiCall.invoke();
        }
        catch (ClientException ex) {
            throw this.clientException(ex);
        }
        catch (ServerException ex) {
            throw this.serverException(ex);
        }
        return (T)object;
    }

    static {
        Type[] typeArray = new Type[]{(Type)((Object)BusinessValidationError.class)};
        jsonAdapterBusinessValidationErrorList = Serializer.getMoshi().adapter((Type)Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])typeArray));
    }
}

