/*
 * Decompiled with CFR 0.152.
 */
package tech.beepbeep.beep_commons.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.beepbeep.beep_commons.util.Constants;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/beepbeep/beep_commons/util/Utils;", "", "()V", "Companion", "module-beep-commons"})
public final class Utils {
    private static final Logger logger;
    @Nullable
    private static String beepPath;
    @NotNull
    public static final String logName = "log.txt";
    @NotNull
    public static final String logName_file1 = "log.txt.0";
    @NotNull
    public static final String logName_file2 = "log.txt.1";
    private static boolean isUploading;
    private static boolean isSetLogPath;
    private static int counter;
    private static boolean isDebug;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        logger = Logger.getLogger("BeepSdk");
        isDebug = true;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0010J\u0010\u0010#\u001a\u00020 2\b\u0010$\u001a\u0004\u0018\u00010\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ltech/beepbeep/beep_commons/util/Utils$Companion;", "", "()V", "beepPath", "", "getBeepPath", "()Ljava/lang/String;", "setBeepPath", "(Ljava/lang/String;)V", "counter", "", "getCounter", "()I", "setCounter", "(I)V", "isDebug", "", "()Z", "setDebug", "(Z)V", "isSetLogPath", "isUploading", "setUploading", "logName", "logName_file1", "logName_file2", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getStringMsg", "msg", "printLog", "", "message", "isHttp", "storeLog", "path", "module-beep-commons"})
    public static final class Companion {
        @Nullable
        public final String getBeepPath() {
            return beepPath;
        }

        public final void setBeepPath(@Nullable String string) {
            beepPath = string;
        }

        public final boolean isUploading() {
            return isUploading;
        }

        public final void setUploading(boolean bl) {
            isUploading = bl;
        }

        public final int getCounter() {
            return counter;
        }

        public final void setCounter(int n) {
            counter = n;
        }

        public final boolean isDebug() {
            return isDebug;
        }

        public final void setDebug(boolean bl) {
            isDebug = bl;
        }

        public final void printLog(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.printLog(this.getStringMsg(message), false);
        }

        public final void printLog(@NotNull String message, boolean isHttp) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            try {
                Logger logger = logger;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
                logger.setLevel(Level.INFO);
                Logger logger2 = logger;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
                logger2.setUseParentHandlers(this.isDebug());
                if (this.isUploading()) {
                    return;
                }
                logger.info(message);
            }
            catch (Exception e) {
                String string = "Print log error: " + e;
                boolean bl = false;
                System.out.println((Object)string);
            }
        }

        private final String getStringMsg(String msg) {
            String string;
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            StackTraceElement[] stackTrace = thread.getStackTrace();
            int index = stackTrace.length > 4 ? 4 : stackTrace.length - 1;
            StackTraceElement stackTraceElement = stackTrace[index];
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"stackTrace[index]");
            String className = stackTraceElement.getFileName();
            StackTraceElement stackTraceElement2 = stackTrace[index];
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement2, (String)"stackTrace[index]");
            String methodName = stackTraceElement2.getMethodName();
            StackTraceElement stackTraceElement3 = stackTrace[index];
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement3, (String)"stackTrace[index]");
            int lineNumber = stackTraceElement3.getLineNumber();
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = methodName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"methodName");
            String string3 = string2;
            int n = 0;
            int n2 = 1;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string = string5;
            n = 0;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toUpperCase()");
            string = string7;
            string3 = methodName;
            n = 1;
            stringBuilder2 = stringBuilder2.append(string);
            n2 = 0;
            String string8 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
            string = string8;
            methodName = stringBuilder2.append(string).toString();
            StringBuilder stringBuilder3 = new StringBuilder();
            StringBuilder stringBuilder4 = stringBuilder3.append("[ (").append(className).append(":").append(lineNumber).append(")#").append(methodName).append("-");
            StringBuilder stringBuilder5 = new StringBuilder().append("{");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"Thread.currentThread()");
            stringBuilder4.append(stringBuilder5.append(thread2.getName()).append("}").toString()).append(" ] ");
            stringBuilder3.append(msg);
            String string9 = stringBuilder3.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"stringBuilder.toString()");
            return string9;
        }

        public final void storeLog(@Nullable String path) {
            if (isSetLogPath) {
                this.printLog("Already set log path!!! no need to set again.");
                return;
            }
            isSetLogPath = true;
            try {
                CharSequence charSequence = path;
                Companion companion = this;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
                companion.setBeepPath(!bl3 ? path + File.separator + "beep" : "./beep");
                String string = this.getBeepPath();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Constants.Companion.setBEEP_PATH(string);
                File file = new File(this.getBeepPath());
                if (!file.exists()) {
                    file.mkdirs();
                }
                FileHandler fileHandler = new FileHandler(this.getBeepPath() + File.separator + Utils.logName, 2560000, 2, true);
                fileHandler.setFormatter(new SimpleFormatter(){
                    private final String format = "%1$tb|%1$td|%1$ty|%1$tH:%1$tM:%1$tS:%1$tL %2$s: %3$s%4$s%n";
                    private final Date dat;

                    @NotNull
                    public String format(@Nullable LogRecord record) {
                        LogRecord logRecord = record;
                        if (logRecord == null) {
                            Intrinsics.throwNpe();
                        }
                        this.dat.setTime(logRecord.getMillis());
                        String message = this.formatMessage(record);
                        String throwable = "";
                        if (record.getThrown() != null) {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            pw.println();
                            record.getThrown().printStackTrace(pw);
                            pw.close();
                            String string = sw.toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sw.toString()");
                            throwable = string;
                        }
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = this.format;
                        Object[] objectArray = new Object[4];
                        objectArray[0] = this.dat;
                        Level level = record.getLevel();
                        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"record.level");
                        objectArray[1] = level.getLocalizedName();
                        objectArray[2] = message;
                        objectArray[3] = throwable;
                        Object[] objectArray2 = objectArray;
                        boolean bl = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                        return string2;
                    }
                    {
                        this.format = "%1$tb|%1$td|%1$ty|%1$tH:%1$tM:%1$tS:%1$tL %2$s: %3$s%4$s%n";
                        this.dat = new Date();
                    }
                });
                logger.addHandler(fileHandler);
            }
            catch (Exception e) {
                String string = "Set log path error~~~ Cannot save Log" + e;
                boolean bl = false;
                System.out.println((Object)string);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

