/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter;

import java.util.Deque;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.avro.AvroTypeException;

class AvroTypeExceptions {
    AvroTypeExceptions() {
    }

    static AvroTypeException enumException(Deque<String> fieldPath, String expectedSymbols) {
        return new AvroTypeException("Field " + AvroTypeExceptions.path(fieldPath) + " is expected to be of enum type and be one of " + expectedSymbols);
    }

    static AvroTypeException unionException(String fieldName, String expectedTypes, Deque<String> offendingPath) {
        return new AvroTypeException("Could not evaluate union, field" + fieldName + "is expected to be one of these: " + expectedTypes + "If this is a complex type, check if offending field: " + AvroTypeExceptions.path(offendingPath) + " adheres to schema.");
    }

    static AvroTypeException typeException(Deque<String> fieldPath, String expectedType) {
        return new AvroTypeException("Field " + AvroTypeExceptions.path(fieldPath) + " is expected to be type: " + expectedType);
    }

    private static String path(Deque<String> path) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(path.descendingIterator(), 16), false).map(Object::toString).collect(Collectors.joining("."));
    }
}

