/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.codehaus.jackson.map.ObjectMapper;
import tech.allegro.schema.json2avro.converter.AvroConversionException;

public class JsonGenericRecordReader {
    private ObjectMapper mapper;

    public JsonGenericRecordReader() {
        this.mapper = new ObjectMapper();
    }

    public JsonGenericRecordReader(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public GenericData.Record read(byte[] data, Schema schema) {
        try {
            return this.read((Map)this.mapper.readValue(data, Map.class), schema);
        }
        catch (IOException ex) {
            throw new AvroConversionException("Failed to parse json to map format.", ex);
        }
    }

    public GenericData.Record read(Map<String, Object> json, Schema schema) {
        try {
            GenericRecordBuilder record = new GenericRecordBuilder(schema);
            json.entrySet().forEach(entry -> Optional.ofNullable(schema.getField((String)entry.getKey())).ifPresent(field -> record.set(field, this.read((Schema.Field)field, field.schema(), entry.getValue()))));
            return record.build();
        }
        catch (AvroRuntimeException ex) {
            throw new AvroConversionException("Failed to convert json to avro.", ex);
        }
    }

    private Object read(Schema.Field field, Schema schema, Object value) {
        switch (schema.getType()) {
            case RECORD: {
                return this.read(this.ensureType(value, Map.class, field), schema);
            }
            case ARRAY: {
                return this.readArray(field, schema, this.ensureType(value, List.class, field));
            }
            case MAP: {
                return this.readMap(field, schema, this.ensureType(value, Map.class, field));
            }
            case UNION: {
                return this.readUnion(field, schema, value);
            }
            case INT: {
                return this.ensureType(value, Number.class, field).intValue();
            }
            case LONG: {
                return this.ensureType(value, Number.class, field).longValue();
            }
            case FLOAT: {
                return Float.valueOf(this.ensureType(value, Number.class, field).floatValue());
            }
            case DOUBLE: {
                return this.ensureType(value, Number.class, field).doubleValue();
            }
            case BOOLEAN: {
                return this.ensureType(value, Boolean.class, field);
            }
            case ENUM: 
            case STRING: {
                return this.ensureType(value, String.class, field);
            }
            case NULL: {
                return this.ensureNull(value, field);
            }
        }
        throw new AvroTypeException("Unsupported type: " + field.schema().getType());
    }

    private List<Object> readArray(Schema.Field field, Schema schema, List<Object> items) {
        return items.stream().map(item -> this.read(field, schema.getElementType(), item)).collect(Collectors.toList());
    }

    private Map<String, Object> readMap(Schema.Field field, Schema schema, Map<String, Object> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.read(field, schema.getValueType(), entry.getValue())));
    }

    private Object readUnion(Schema.Field field, Schema schema, Object value) {
        List types = schema.getTypes();
        for (Schema type : types) {
            try {
                return this.read(field, type, value);
            }
            catch (AvroRuntimeException ex) {
            }
        }
        throw new AvroTypeException(String.format("Could not evaluate union, field %s is expected to be one of these: %s.", field.name(), types.stream().map(Schema::getType).map(Object::toString).collect(Collectors.joining(","))));
    }

    private <T> T ensureType(Object value, Class<T> type, Schema.Field field) {
        if (type.isInstance(value)) {
            return (T)value;
        }
        throw new AvroTypeException(String.format("Field %s is expected to be of %s type.", field.name(), type.getName()));
    }

    private Object ensureNull(Object o, Schema.Field field) {
        if (o != null) {
            throw new AvroTypeException(String.format("Field %s was expected to be null.", field.name()));
        }
        return null;
    }
}

