/*
 * Decompiled with CFR 0.152.
 */
package tech.alexib.plaid.client.infrastructure;

import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.InputArraysKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.PacketJVMKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002\u001a\f\u0010\u0012\u001a\u00020\f*\u00020\u0001H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0001*\u00020\u0014H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0001*\u00020\fH\u0000\u001a\f\u0010\u0016\u001a\u00020\u0005*\u00020\u0005H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0007*\u00020\u0011H\u0002\u001a\f\u0010\u0018\u001a\u00020\t*\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"BASE64_ALPHABET", "", "BASE64_INVERSE_ALPHABET", "", "BASE64_MASK", "", "BASE64_PAD", "", "digits", "", "hex", "bytes", "", "s", "clearFrom", "", "from", "", "decodeBase64Bytes", "Lio/ktor/utils/io/core/Input;", "Lio/ktor/utils/io/core/ByteReadPacket;", "encodeBase64", "fromBase64", "toBase64", "toCharArray", "plaid-kotlin"})
public final class BytesKt {
    @NotNull
    private static final char[] digits = BytesKt.toCharArray("0123456789abcdef");
    @NotNull
    private static final String BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final byte BASE64_MASK = 63;
    private static final char BASE64_PAD = '=';
    @NotNull
    private static final int[] BASE64_INVERSE_ALPHABET;

    private static final char[] toCharArray(String $this$toCharArray) {
        int n = 0;
        int n2 = $this$toCharArray.length();
        char[] cArray = new char[n2];
        while (n < n2) {
            int n3 = n++;
            cArray[n3] = $this$toCharArray.charAt(n3);
        }
        return cArray;
    }

    private static final void clearFrom(byte[] $this$clearFrom, int from) {
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)from, (int)$this$clearFrom.length);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            $this$clearFrom[it] = 0;
        }
    }

    private static final char toBase64(int $this$toBase64) {
        return BASE64_ALPHABET.charAt($this$toBase64);
    }

    private static final byte fromBase64(byte $this$fromBase64) {
        byte by = (byte)BASE64_INVERSE_ALPHABET[$this$fromBase64 & 0xFF];
        int n = 63;
        boolean bl = false;
        return (byte)(by & n);
    }

    @NotNull
    public static final String encodeBase64(@NotNull byte[] $this$encodeBase64) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$encodeBase64, (String)"<this>");
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $this$encodeBase64_u24lambda_u2d1 = builder$iv;
            boolean bl2 = false;
            OutputKt.writeFully$default((Output)((Output)$this$encodeBase64_u24lambda_u2d1), (byte[])$this$encodeBase64, (int)0, (int)0, (int)6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return BytesKt.encodeBase64(byteReadPacket);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] decodeBase64Bytes(@NotNull String $this$decodeBase64Bytes) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64Bytes, (String)"<this>");
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            String string;
            Output output;
            block4: {
                void $this$dropLastWhile$iv;
                BytePacketBuilder $this$decodeBase64Bytes_u24lambda_u2d3 = builder$iv;
                boolean bl2 = false;
                String string2 = $this$decodeBase64Bytes;
                output = (Output)$this$decodeBase64Bytes_u24lambda_u2d3;
                boolean $i$f$dropLastWhile = false;
                int n = StringsKt.getLastIndex((CharSequence)((CharSequence)$this$dropLastWhile$iv));
                boolean bl3 = false;
                while (n >= 0) {
                    void index$iv;
                    char it = $this$dropLastWhile$iv.charAt((int)index$iv);
                    boolean bl4 = false;
                    if (!(it == '=')) {
                        void var11_14 = $this$dropLastWhile$iv;
                        int n2 = 0;
                        void var13_16 = index$iv + true;
                        boolean bl5 = false;
                        String string3 = var11_14.substring(n2, (int)var13_16);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block4;
                    }
                    --index$iv;
                }
                string = "";
            }
            String string4 = string;
            io.ktor.utils.io.core.StringsKt.writeText$default((Output)output, (CharSequence)string4, (int)0, (int)0, null, (int)14, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return io.ktor.utils.io.core.StringsKt.readBytes((Input)BytesKt.decodeBase64Bytes(byteReadPacket));
    }

    @NotNull
    public static final String hex(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        char[] result = new char[bytes.length * 2];
        int resultIndex = 0;
        char[] digits = BytesKt.digits;
        for (byte element : bytes) {
            int b = element & 0xFF;
            int n = resultIndex;
            resultIndex = n + 1;
            result[n] = digits[b >> 4];
            n = resultIndex;
            resultIndex = n + 1;
            result[n] = digits[b & 0xF];
        }
        boolean bl = false;
        return new String(result);
    }

    @NotNull
    public static final byte[] hex(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] result = new byte[s.length() / 2];
        int n = 0;
        int n2 = result.length + -1;
        if (n <= n2) {
            do {
                int idx = n++;
                int srcIdx = idx * 2;
                String string = String.valueOf(s.charAt(srcIdx));
                int n3 = 16;
                int n4 = 0;
                int high = Integer.parseInt(string, CharsKt.checkRadix((int)n3)) << 4;
                String string2 = String.valueOf(s.charAt(srcIdx + 1));
                n4 = 16;
                boolean bl = false;
                int low = Integer.parseInt(string2, CharsKt.checkRadix((int)n4));
                result[idx] = (byte)(high | low);
            } while (n <= n2);
        }
        return result;
    }

    private static final String encodeBase64(ByteReadPacket $this$encodeBase64) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$encodeBase64_u24lambda_u2d5 = stringBuilder;
        boolean bl5 = false;
        byte[] data = new byte[3];
        while ($this$encodeBase64.getRemaining() > 0L) {
            int read = InputArraysKt.readAvailable$default((Input)((Input)$this$encodeBase64), (byte[])data, (int)0, (int)0, (int)6, null);
            BytesKt.clearFrom(data, read);
            int padSize = (data.length - read) * 8 / 6;
            int chunk = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
            int n = data.length;
            if (padSize <= n) {
                int index;
                do {
                    index = n--;
                    int n2 = chunk >> 6 * index & 0x3F;
                    $this$encodeBase64_u24lambda_u2d5.append(BytesKt.toBase64(n2));
                } while (index != padSize);
            }
            n = 0;
            int n3 = 0;
            n3 = 0;
            int n4 = padSize;
            while (n3 < n4) {
                int it = n3++;
                boolean bl6 = false;
                $this$encodeBase64_u24lambda_u2d5.append('=');
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final Input decodeBase64Bytes(ByteReadPacket $this$decodeBase64Bytes) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $this$decodeBase64Bytes_u24lambda_u2d7 = builder$iv;
            boolean bl2 = false;
            byte[] data = new byte[4];
            while ($this$decodeBase64Bytes.getRemaining() > 0L) {
                int index;
                void $this$foldIndexed$iv;
                int read = InputArraysKt.readAvailable$default((Input)((Input)$this$decodeBase64Bytes), (byte[])data, (int)0, (int)0, (int)6, null);
                byte[] byArray = data;
                int initial$iv = 0;
                boolean $i$f$foldIndexed = false;
                int index$iv = 0;
                int accumulator$iv = initial$iv;
                for (void element$iv : $this$foldIndexed$iv) {
                    void current;
                    void result;
                    int n = index$iv++;
                    void var17_20 = element$iv;
                    int n2 = accumulator$iv;
                    int index2 = n;
                    boolean bl3 = false;
                    accumulator$iv = result | BytesKt.fromBase64((byte)current) << (3 - index2) * 6;
                }
                int chunk = accumulator$iv;
                int n = data.length - read;
                int n3 = data.length - 2;
                if (n > n3) continue;
                do {
                    index = n3--;
                    int origin = chunk >> 8 * index & 0xFF;
                    $this$decodeBase64Bytes_u24lambda_u2d7.writeByte((byte)origin);
                } while (index != n);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return (Input)byteReadPacket;
    }

    static {
        int n = 0;
        int[] nArray = new int[256];
        while (n < 256) {
            int n2 = n++;
            nArray[n2] = StringsKt.indexOf$default((CharSequence)BASE64_ALPHABET, (char)((char)n2), (int)0, (boolean)false, (int)6, null);
        }
        BASE64_INVERSE_ALPHABET = nArray;
    }
}

