/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.widget;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Typeface;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.HorizontalScrollView;
import android.widget.TextView;
import org.iqnect.iqkit.ui.widget.SlidingTabStrip;

public class SlidingTabLayout
extends HorizontalScrollView {
    private static final int TITLE_OFFSET_DIPS = 24;
    private static final int TAB_VIEW_PADDING_DIPS = 16;
    private static final int TAB_VIEW_TEXT_SIZE_SP = 12;
    private int mTitleOffset;
    private int mTabViewLayoutId;
    private int mTabViewTextViewId;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mViewPagerPageChangeListener;
    private final SlidingTabStrip mTabStrip;
    private int mSplitTabCount;
    private int mTextColor;

    public SlidingTabLayout(Context context) {
        this(context, null);
    }

    public SlidingTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingTabLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setHorizontalScrollBarEnabled(false);
        this.setFillViewport(true);
        this.mTitleOffset = (int)(24.0f * this.getResources().getDisplayMetrics().density);
        this.mTabStrip = new SlidingTabStrip(context);
        this.addView((View)this.mTabStrip, -1, -2);
    }

    public void setCustomTabColorizer(TabColorizer tabColorizer) {
        this.mTabStrip.setCustomTabColorizer(tabColorizer);
    }

    public void setSelectedIndicatorColors(int ... colors) {
        this.mTabStrip.setSelectedIndicatorColors(colors);
    }

    public void setDividerColors(int ... colors) {
        this.mTabStrip.setDividerColors(colors);
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mViewPagerPageChangeListener = listener;
    }

    public void setCustomTabView(int layoutResId, int textViewId) {
        this.mTabViewLayoutId = layoutResId;
        this.mTabViewTextViewId = textViewId;
    }

    public void setViewPager(ViewPager viewPager) {
        this.mTabStrip.removeAllViews();
        this.mViewPager = viewPager;
        if (viewPager != null) {
            viewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new InternalViewPagerListener());
            this.populateTabStrip();
        }
    }

    protected TextView createDefaultTabView(Context context) {
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setTextSize(2, 12.0f);
        textView.setTypeface(Typeface.DEFAULT_BOLD);
        textView.setTextColor(this.mTextColor != 0 ? this.mTextColor : -1);
        TypedValue outValue = new TypedValue();
        this.getContext().getTheme().resolveAttribute(16843534, outValue, true);
        textView.setBackgroundResource(outValue.resourceId);
        textView.setAllCaps(true);
        int padding = (int)(16.0f * this.getResources().getDisplayMetrics().density);
        textView.setPadding(padding, padding, padding, padding);
        if (this.mSplitTabCount > 0) {
            WindowManager wm = (WindowManager)context.getSystemService("window");
            Display display = wm.getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            textView.setWidth(size.x / this.mSplitTabCount);
        }
        return textView;
    }

    private void populateTabStrip() {
        PagerAdapter adapter = this.mViewPager.getAdapter();
        TabClickListener tabClickListener = new TabClickListener();
        for (int i = 0; i < adapter.getCount(); ++i) {
            TextView tabView = null;
            TextView tabTitleView = null;
            if (this.mTabViewLayoutId != 0) {
                tabView = LayoutInflater.from((Context)this.getContext()).inflate(this.mTabViewLayoutId, (ViewGroup)this.mTabStrip, false);
                tabTitleView = (TextView)tabView.findViewById(this.mTabViewTextViewId);
            }
            if (tabView == null) {
                tabView = this.createDefaultTabView(this.getContext());
            }
            if (tabTitleView == null && TextView.class.isInstance(tabView)) {
                tabTitleView = tabView;
            }
            if (tabTitleView != null) {
                tabTitleView.setText(adapter.getPageTitle(i));
            }
            tabView.setOnClickListener((View.OnClickListener)tabClickListener);
            this.mTabStrip.addView((View)tabView);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mViewPager != null) {
            this.scrollToTab(this.mViewPager.getCurrentItem(), 0);
        }
    }

    private void scrollToTab(int tabIndex, int positionOffset) {
        int tabStripChildCount = this.mTabStrip.getChildCount();
        if (tabStripChildCount == 0 || tabIndex < 0 || tabIndex >= tabStripChildCount) {
            return;
        }
        View selectedChild = this.mTabStrip.getChildAt(tabIndex);
        if (selectedChild != null) {
            int targetScrollX = selectedChild.getLeft() + positionOffset;
            if (tabIndex > 0 || positionOffset > 0) {
                targetScrollX -= this.mTitleOffset;
            }
            this.scrollTo(targetScrollX, 0);
        }
    }

    public int getSplitTabCount() {
        return this.mSplitTabCount;
    }

    public void setSplitTabCount(int mSplitTabCount) {
        this.mSplitTabCount = mSplitTabCount;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int mTextColor) {
        this.mTextColor = mTextColor;
    }

    private class TabClickListener
    implements View.OnClickListener {
        private TabClickListener() {
        }

        public void onClick(View v) {
            for (int i = 0; i < SlidingTabLayout.this.mTabStrip.getChildCount(); ++i) {
                if (v != SlidingTabLayout.this.mTabStrip.getChildAt(i)) continue;
                SlidingTabLayout.this.mViewPager.setCurrentItem(i);
                return;
            }
        }
    }

    private class InternalViewPagerListener
    implements ViewPager.OnPageChangeListener {
        private int mScrollState;

        private InternalViewPagerListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int tabStripChildCount = SlidingTabLayout.this.mTabStrip.getChildCount();
            if (tabStripChildCount == 0 || position < 0 || position >= tabStripChildCount) {
                return;
            }
            SlidingTabLayout.this.mTabStrip.onViewPagerPageChanged(position, positionOffset);
            View selectedTitle = SlidingTabLayout.this.mTabStrip.getChildAt(position);
            int extraOffset = selectedTitle != null ? (int)(positionOffset * (float)selectedTitle.getWidth()) : 0;
            SlidingTabLayout.this.scrollToTab(position, extraOffset);
            if (SlidingTabLayout.this.mViewPagerPageChangeListener != null) {
                SlidingTabLayout.this.mViewPagerPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            this.mScrollState = state;
            if (SlidingTabLayout.this.mViewPagerPageChangeListener != null) {
                SlidingTabLayout.this.mViewPagerPageChangeListener.onPageScrollStateChanged(state);
            }
        }

        public void onPageSelected(int position) {
            if (this.mScrollState == 0) {
                SlidingTabLayout.this.mTabStrip.onViewPagerPageChanged(position, 0.0f);
                SlidingTabLayout.this.scrollToTab(position, 0);
            }
            if (SlidingTabLayout.this.mViewPagerPageChangeListener != null) {
                SlidingTabLayout.this.mViewPagerPageChangeListener.onPageSelected(position);
            }
        }
    }

    public static interface TabColorizer {
        public int getIndicatorColor(int var1);

        public int getDividerColor(int var1);
    }
}

