/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.google.common.base.Objects;
import com.makeramen.roundedimageview.RoundedImageView;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import lombok.NonNull;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.injection.UIComponentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteImageView
extends RoundedImageView {
    private static final Logger log = LoggerFactory.getLogger(RemoteImageView.class);
    private final int mPlaceholderResource;
    private final int mErrorResource;
    @Nullable
    private Uri mUri;
    private int mWidth;
    private int mHeight;
    private boolean mResize = true;

    public RemoteImageView(@NonNull Context context) {
        this(context, null);
        if (context == null) {
            throw new NullPointerException("context");
        }
    }

    public RemoteImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
        if (context == null) {
            throw new NullPointerException("context");
        }
    }

    public RemoteImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (context == null) {
            throw new NullPointerException("context");
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RemoteImageView, defStyle, 0);
        this.mPlaceholderResource = a.getResourceId(R.styleable.RemoteImageView_placeholderDrawable, 0);
        this.mErrorResource = a.getResourceId(R.styleable.RemoteImageView_errorDrawable, 0);
        a.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.updateDimensions();
    }

    public void setUri(@Nullable String uriString) {
        this.setUri(!TextUtils.isEmpty((CharSequence)uriString) ? Uri.parse((String)uriString) : null);
    }

    public void setUri(@Nullable Uri uri) {
        if (!Objects.equal((Object)uri, (Object)this.mUri)) {
            this.mUri = uri;
            this.invalidateBitmap();
        }
    }

    private void updateDimensions() {
        this.changeDimensions(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
    }

    private void changeDimensions(int width, int height) {
        if (width != this.mWidth || height != this.mHeight) {
            this.mWidth = width;
            this.mHeight = height;
            this.invalidateBitmap();
        }
    }

    private void invalidateBitmap() {
        this.load();
    }

    private void load() {
        if (this.isInEditMode()) {
            return;
        }
        log.debug("loading RemoteImageView. size: ({}, {}), scaletype: {}", new Object[]{this.mWidth, this.mHeight, this.getScaleType()});
        if (this.mUri == null) {
            log.debug("uri is null, removing drawable");
            this.setImageDrawable(null);
        } else if (this.mWidth > 0 && this.mHeight > 0) {
            Picasso picasso = UIComponentFactory.getInstance(this.getContext().getApplicationContext()).getUIPicasso();
            RequestCreator requestCreator = picasso.load(this.mUri);
            if (this.mPlaceholderResource > 0) {
                requestCreator.placeholder(this.mPlaceholderResource);
            }
            if (this.mErrorResource > 0) {
                requestCreator.error(this.mErrorResource);
            }
            if (this.mResize) {
                requestCreator.resize(this.mWidth, this.mHeight);
                switch (this.getScaleType()) {
                    case CENTER_CROP: {
                        requestCreator.centerCrop();
                        break;
                    }
                    case FIT_CENTER: 
                    case CENTER_INSIDE: {
                        requestCreator.centerInside();
                    }
                }
            }
            requestCreator.into((ImageView)this);
        }
    }

    @Nullable
    public Uri getUri() {
        return this.mUri;
    }

    public boolean isResize() {
        return this.mResize;
    }

    public void setResize(boolean mResize) {
        this.mResize = mResize;
    }
}

