/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.widget;

import android.graphics.Rect;
import android.support.annotation.Px;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public final class GridSpaceDecoration
extends RecyclerView.ItemDecoration {
    @Px
    private final int mItemSpacing;
    private final int mColumnCount;

    public GridSpaceDecoration(@Px int itemSpacing, int columnCount) {
        this.mItemSpacing = itemSpacing;
        this.mColumnCount = columnCount;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int itemCount = state.getItemCount();
        int position = parent.getChildAdapterPosition(view);
        boolean left = position % this.mColumnCount == 0;
        boolean right = position % this.mColumnCount == this.mColumnCount - 1;
        boolean top = position < this.mColumnCount;
        int bottomRowCount = itemCount % this.mColumnCount;
        boolean bottom = position > itemCount - bottomRowCount;
        int leftPadding = left ? this.mItemSpacing : this.mItemSpacing / 2;
        int rightPadding = right ? this.mItemSpacing : this.mItemSpacing / 2;
        int topPadding = top ? this.mItemSpacing : this.mItemSpacing / 2;
        int bottomPadding = bottom ? this.mItemSpacing : this.mItemSpacing / 2;
        view.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
    }
}

