/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import lombok.NonNull;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int[] ATTRS = new int[]{16843284};
    @NonNull
    private final Drawable mDivider;

    public DividerItemDecoration(Context context) {
        TypedArray styledAttributes = context.obtainStyledAttributes(ATTRS);
        Drawable divider = styledAttributes.getDrawable(0);
        if (divider == null) {
            throw new NullPointerException("android:listDivider not specified");
        }
        this.mDivider = divider;
        styledAttributes.recycle();
    }

    public DividerItemDecoration(Context context, int resId) {
        this.mDivider = ContextCompat.getDrawable((Context)context, (int)resId);
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + params.bottomMargin;
            int bottom = top + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }
}

