/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.webkit;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.iqnect.iqkit.ui.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IqWebViewClient
extends WebViewClient {
    private static final Logger log = LoggerFactory.getLogger(IqWebViewClient.class);
    private Context mContext;
    @NonNull
    private Collection<WebViewListener> mListeners = new CopyOnWriteArrayList<WebViewListener>();
    private boolean mClearHistory;

    public IqWebViewClient(Context context) {
        this.mContext = context;
    }

    public void addListener(@NonNull WebViewListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(@NonNull WebViewListener listener) {
        this.mListeners.remove(listener);
    }

    public void clearHistory() {
        this.mClearHistory = true;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        log.debug("should override? {}", (Object)url);
        for (WebViewListener listener : this.mListeners) {
            if (!listener.shouldOverrideUrlLoading(url)) continue;
            return true;
        }
        return super.shouldOverrideUrlLoading(view, url);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        log.debug("onPageStarted {}", (Object)url);
        for (WebViewListener listener : this.mListeners) {
            listener.onPageStarted(view, url);
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        log.debug("onPageFinished {}", (Object)url);
        for (WebViewListener listener : this.mListeners) {
            listener.onPageFinished(view, url);
        }
        if (this.mClearHistory) {
            this.mClearHistory = false;
            view.clearHistory();
        }
    }

    public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
        log.debug("onReceivedSslError {}", (Object)view.getUrl());
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setTitle(R.string.dialog_title_ssl);
        builder.setMessage(R.string.dialog_message_ssl);
        builder.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                handler.cancel();
            }
        });
        builder.setPositiveButton(R.string.continue_text, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                handler.proceed();
            }
        });
        builder.show();
    }

    public static class SimpleWebViewListener
    implements WebViewListener {
        @Override
        public void onPageStarted(@NonNull WebView view, @NonNull String url) {
        }

        @Override
        public void onPageFinished(WebView view, String url) {
        }

        @Override
        public boolean shouldOverrideUrlLoading(String url) {
            return false;
        }
    }

    public static interface WebViewListener {
        public void onPageStarted(@NonNull WebView var1, @NonNull String var2);

        public void onPageFinished(WebView var1, String var2);

        public boolean shouldOverrideUrlLoading(String var1);
    }
}

