/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.webkit;

import android.media.MediaPlayer;
import android.support.annotation.Nullable;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.VideoView;
import org.iqnect.iqkit.ui.webkit.IqWebView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IqWebChromeClient
extends WebChromeClient
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    private static final Logger log = LoggerFactory.getLogger(IqWebChromeClient.class);
    @Nullable
    private View mNonVideoView;
    @Nullable
    private ViewGroup mVideoView;
    @Nullable
    private View mLoadingView;
    @Nullable
    private IqWebView mWebView;
    @Nullable
    private FrameLayout mVideoViewContainer;
    @Nullable
    private WebChromeClient.CustomViewCallback mVideoViewCallback;
    @Nullable
    private ToggledFullscreenCallback mToggledFullscreenCallback;
    private boolean mVideoFullscreen;

    public IqWebChromeClient(@Nullable View nonVideoView, @Nullable ViewGroup videoView) {
        this.mNonVideoView = nonVideoView;
        this.mVideoView = videoView;
        this.mLoadingView = null;
        this.mWebView = null;
        this.mVideoFullscreen = false;
    }

    public IqWebChromeClient(@Nullable View nonVideoView, @Nullable ViewGroup videoView, @Nullable View loadingView) {
        this.mNonVideoView = nonVideoView;
        this.mVideoView = videoView;
        this.mLoadingView = loadingView;
        this.mWebView = null;
        this.mVideoFullscreen = false;
    }

    public IqWebChromeClient(@Nullable View nonVideoView, @Nullable ViewGroup videoView, @Nullable View loadingView, @Nullable IqWebView webView) {
        this.mNonVideoView = nonVideoView;
        this.mVideoView = videoView;
        this.mLoadingView = loadingView;
        this.mWebView = webView;
        this.mVideoFullscreen = false;
    }

    public boolean isVideoFullscreen() {
        return this.mVideoFullscreen;
    }

    public void setOnToggledFullscreen(@Nullable ToggledFullscreenCallback callback) {
        this.mToggledFullscreenCallback = callback;
    }

    public void onShowCustomView(@Nullable View view, WebChromeClient.CustomViewCallback callback) {
        log.debug("onShowCustomView: {}", (Object)view);
        if (view != null && view instanceof FrameLayout && this.mVideoView != null) {
            FrameLayout frameLayout = (FrameLayout)view;
            View focusedChild = frameLayout.getFocusedChild();
            this.mVideoFullscreen = true;
            this.mVideoViewContainer = frameLayout;
            this.mVideoViewCallback = callback;
            if (this.mNonVideoView != null) {
                this.mNonVideoView.setVisibility(4);
            }
            this.mVideoView.addView((View)this.mVideoViewContainer, new ViewGroup.LayoutParams(-1, -1));
            this.mVideoView.setVisibility(0);
            if (focusedChild instanceof VideoView) {
                VideoView videoView = (VideoView)focusedChild;
                videoView.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
                videoView.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
                videoView.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            } else if (this.mWebView != null && this.mWebView.getSettings().getJavaScriptEnabled() && focusedChild instanceof SurfaceView) {
                String js = "javascript:";
                js = js + "var _ytrp_html5_video_last;";
                js = js + "var _ytrp_html5_video = document.getElementsByTagName('video')[0];";
                js = js + "if (_ytrp_html5_video != undefined && _ytrp_html5_video != _ytrp_html5_video_last) {";
                js = js + "_ytrp_html5_video_last = _ytrp_html5_video;";
                js = js + "function _ytrp_html5_video_ended() {";
                js = js + "_VideoEnabledWebView.notifyVideoEnd();";
                js = js + "}";
                js = js + "_ytrp_html5_video.addEventListener('ended', _ytrp_html5_video_ended);";
                js = js + "}";
                this.mWebView.loadUrl(js);
            }
            if (this.mToggledFullscreenCallback != null) {
                this.mToggledFullscreenCallback.toggledFullscreen(true);
            }
        }
    }

    public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
        this.onShowCustomView(view, callback);
    }

    public void onHideCustomView() {
        if (this.mVideoFullscreen && this.mVideoView != null && this.mVideoViewContainer != null) {
            this.mVideoView.setVisibility(4);
            this.mVideoView.removeView((View)this.mVideoViewContainer);
            if (this.mNonVideoView != null) {
                this.mNonVideoView.setVisibility(0);
            }
            if (this.mVideoViewCallback != null && !this.mVideoViewCallback.getClass().getName().contains(".chromium.")) {
                this.mVideoViewCallback.onCustomViewHidden();
            }
            this.mVideoFullscreen = false;
            this.mVideoViewContainer = null;
            this.mVideoViewCallback = null;
            if (this.mToggledFullscreenCallback != null) {
                this.mToggledFullscreenCallback.toggledFullscreen(false);
            }
        }
    }

    public View getVideoLoadingProgressView() {
        if (this.mLoadingView != null) {
            this.mLoadingView.setVisibility(0);
            return this.mLoadingView;
        }
        return super.getVideoLoadingProgressView();
    }

    public void onPrepared(MediaPlayer mp) {
        if (this.mLoadingView != null) {
            this.mLoadingView.setVisibility(8);
        }
    }

    public void onCompletion(MediaPlayer mp) {
        this.onHideCustomView();
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        return false;
    }

    public void destroy() {
        this.mToggledFullscreenCallback = null;
        this.mVideoViewCallback = null;
        this.mNonVideoView = null;
        this.mVideoView = null;
        this.mVideoViewContainer = null;
        this.mLoadingView = null;
        this.mWebView = null;
    }

    public boolean onBackPressed() {
        if (this.mVideoFullscreen) {
            this.onHideCustomView();
            return true;
        }
        return false;
    }

    public static interface ToggledFullscreenCallback {
        public void toggledFullscreen(boolean var1);
    }
}

