/*
 * Decompiled with CFR 0.152.
 */
package org.iqnect.iqkit.ui.web;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import butterknife.BindView;
import lombok.NonNull;
import org.iqnect.iqkit.ui.R;
import org.iqnect.iqkit.ui.app.BaseFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class WebFragment
extends BaseFragment {
    private static final Logger log = LoggerFactory.getLogger(WebFragment.class);
    protected static final String ARG_TITLE = "title";
    protected static final String ARG_URL = "url";
    @Nullable
    protected WebView mWebView;
    @BindView(value=2131689677)
    ViewGroup mWebViewContainer;
    @Nullable
    @BindView(value=2131689678)
    ProgressBar mProgressBar;
    @NonNull
    private String mUrl;
    @Nullable
    private String mTitle;

    @NonNull
    public static WebFragment create(@NonNull String url, @Nullable String title) {
        if (url == null) {
            throw new NullPointerException(ARG_URL);
        }
        WebFragment fragment = new WebFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, url);
        args.putString(ARG_TITLE, title);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String url = this.getArguments().getString(ARG_URL);
        if (url == null) {
            throw new NullPointerException();
        }
        this.mTitle = this.getArguments().getString(ARG_TITLE);
        this.mUrl = url;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.web_fragment, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mWebView = new WebView((Context)this.getActivity());
        WebSettings settings = this.mWebView.getSettings();
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setAppCacheEnabled(true);
        settings.setBuiltInZoomControls(true);
        settings.setDisplayZoomControls(false);
        settings.setJavaScriptEnabled(true);
        this.mWebViewContainer.addView((View)this.mWebView);
        this.updateView();
    }

    @Override
    public void onDestroyView() {
        if (this.mWebViewContainer != null) {
            this.mWebViewContainer.removeAllViews();
            this.mWebViewContainer = null;
        }
        if (this.mWebView != null) {
            if (!this.mWebView.isShown()) {
                this.mWebView.stopLoading();
            }
            this.mWebView.setWebChromeClient(null);
            this.mWebView.setWebViewClient(null);
            this.mWebView.destroy();
            this.mWebView = null;
        }
        super.onDestroyView();
    }

    public void updateView() {
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(@NonNull WebView view, @NonNull String url, Bitmap favicon) {
                if (view == null) {
                    throw new NullPointerException("view");
                }
                if (url == null) {
                    throw new NullPointerException(WebFragment.ARG_URL);
                }
                super.onPageStarted(view, url, favicon);
                if (WebFragment.this.mProgressBar != null) {
                    WebFragment.this.mProgressBar.setProgress(0);
                    WebFragment.this.mProgressBar.setVisibility(0);
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (WebFragment.this.mProgressBar != null) {
                    WebFragment.this.mProgressBar.setProgress(100);
                    WebFragment.this.mProgressBar.setVisibility(8);
                }
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int progress) {
                super.onProgressChanged(view, progress);
                if (WebFragment.this.mProgressBar != null) {
                    WebFragment.this.mProgressBar.setProgress(progress);
                }
            }
        });
        this.mWebView.loadUrl(this.mUrl);
    }

    @NonNull
    public String getUrl() {
        return this.mUrl;
    }

    @Nullable
    public String getTitle() {
        return this.mTitle;
    }
}

